data <- read.csv("/Users/teppeigoto/Desktop/RIKEN CCO/Project/Ongoing Project/Menopausal transion of KNDy neuron/Photometry/Reproductive age/36f7/Kiss1-36f7_200328_Ch2.csv", header = T) #読み込んだデータが表示される
names(data)

newdata_on<-subset(data, Time.s.<=23400 & Time.s.>=1800)
newdata_on1<-sweep(newdata_on,2,c(1800,0))
write.csv(newdata_on1, "Kiss1-36f7_200328_P_lighton.csv", row.names=FALSE)

newdata_off<-subset(data, Time.s.<66600 &Time.s.>=45000)
newdata_off1<-sweep(newdata_off,2,c(45000,0))
write.csv(newdata_off1, "Kiss1-36f7_200328_P_lightoff.csv", row.names=FALSE)
#ここまでで、onとoffの生データを6hごとに抜き出せたので、Doric studioでdF変換する。

dataon <- read.csv("/Users/teppeigoto/Desktop/RIKEN CCO/Project/Ongoing Project/Menopausal transion of KNDy neuron/Photometry/Reproductive age/36f7/Kiss1-36f7_200328_P_lighton_244-600_dF.csv", header = T) #読み込んだデータが表示される
names(dataon)

x1<-dataon$Time.s./3600 #secからhourに変換
y1<-dataon$Analog.In....Ch.2.AIn.2...Dem..AOut.2._BandStop_dF.F0

png("Kiss1-36f7_200328_P_lighton.png", width = 2000, height = 600, bg="transparent")
#X軸、Y軸を表示します。
xmin=0#X軸の最小値
xmax=6#X軸の最大値
xint=1#X軸の間隔
ymin=-50#Y軸の最小値
ymax=300#Y軸の最大値
yint=50#Y軸の間隔
plot(x1,y1,type="l", pch=16, cex=1, lwd=1,las=1, bg="transparent", xlim=c(xmin, xmax), ylim=c(ymin, ymax),axes=FALSE,an=FALSE)

axis(2,at=seq(ymin, ymax,yint), tcl=0.3, mgp=c(1,0.5,0.5),lwd=2,las=1)
axis(1,at=seq(xmin, xmax, xint), labels=c("0","1","2","3", "4", "5","6"), tcl=0.5, mgp=c(0,0.5,0),lwd=2,las=1)

mtext("∆F/F (%)", side=2, line=2.5, cex=1)
mtext("Time (h)", side=1, line=1.5, cex=1)
dev.off()


dataoff <- read.csv("/Users/teppeigoto/Desktop/RIKEN CCO/Project/Ongoing Project/Menopausal transion of KNDy neuron/Photometry/Reproductive age/36f7/Kiss1-36f7_200328_P_lightoff_244-600_dF.csv", header = T) #読み込んだデータが表示される
names(dataoff)

x1<-dataoff$Time.s./3600 #secからhourに変換
y1<-dataoff$Analog.In....Ch.2.AIn.2...Dem..AOut.2._BandStop_dF.F0

png("Kiss1-36f7_200328_P_lightoff.png", width = 2000, height = 600, bg="transparent")
#X軸、Y軸を表示します。
xmin=0#X軸の最小値
xmax=6#X軸の最大値
xint=1#X軸の間隔
ymin=-50#Y軸の最小値
ymax=300#Y軸の最大値
yint=50#Y軸の間隔
plot(x1,y1,type="l", pch=16, cex=1, lwd=1,las=1, bg="transparent", xlim=c(xmin, xmax), ylim=c(ymin, ymax),axes=FALSE,an=FALSE)

axis(2,at=seq(ymin, ymax,yint), tcl=0.3, mgp=c(1,0.5,0.5),lwd=2,las=1)
axis(1,at=seq(xmin, xmax, xint), labels=c("0","1","2","3", "4", "5","6"), tcl=0.5, mgp=c(0,0.5,0),lwd=2,las=1)

mtext("∆F/F (%)", side=2, line=2.5, cex=1)
mtext("Time (h)", side=1, line=1.5, cex=1)
dev.off()


#パルス間隔などの解析
par(mfrow=c(1,1))#Quartzデバイスに出力する際にひとつのウインドウに出力するグラフの数を指定します。現在はひとつのグラフを描きます。
par(pin=c(2.0,0.8), cex=12/12)#plotSizeを規定します。現在は3x2インチ。cex=12/12は文字サイズなどが12ポイントであることを示す。


#カテゴライズした各性周期ごとのFWHM, Left side HM, right side HM, HMじゃなくてmax/3, max/4も計算 

SEanalysisdata_36f7_200328_light <- read.csv("/Users/teppeigoto/Desktop/RIKEN CCO/Project/Ongoing Project/Menopausal transion of KNDy neuron/Photometry/Time course/36f7/200328/Raw data/Kiss1-36f7_200328_P_lighton.csv", header = T)#読み込んだデータが表示される
names(SEanalysisdata_36f7_200328_light)

peakID1_36f7_200328_light<-subset(SEanalysisdata_36f7_200328_light, Time.s.>0.33*3600 & Time.s.<0.67*3600, c(Time.s.,Analog.In....Ch.2.AIn.2...Dem..AOut.2.))#６h PNGファイルから目視でピーク前後の時間数を入力

peakID1max_36f7_200328_light<-subset(peakID1_36f7_200328_light, Analog.In....Ch.2.AIn.2...Dem..AOut.2. == max(Analog.In....Ch.2.AIn.2...Dem..AOut.2.))
peakID1max_36f7_200328_light#最大値すなわちPeakを見つけ出す

xpeakID1max_36f7_200328_light<-peakID1max_36f7_200328_light$Time.s.
xpeakID1max_36f7_200328_light#最大値すなわちPeakの時間を指定

xpeakID1maxh_36f7_200328_light<-xpeakID1max_36f7_200328_light/3600
xpeakID1maxh_36f7_200328_light#最大値すなわちPeakの時間を指定、時間表示なので、思ったものか６h PNGファイルで確認。

ypeakID1max_36f7_200328_light<-peakID1max_36f7_200328_light$Analog.In....Ch.2.AIn.2...Dem..AOut.2.
ypeakID1max_36f7_200328_light#最大値すなわちPeakのRaw値を指定

peakIDm1_36f7_200328_light<-subset(SEanalysisdata_36f7_200328_light, Time.s.>xpeakID1max_36f7_200328_light-120 & Time.s.<xpeakID1max_36f7_200328_light+120, c(Time.s.,Analog.In....Ch.2.AIn.2...Dem..AOut.2.))#最大値すなわちPeakから前後120sのデータだけひっぱてくる。
peakIDm1_36f7_200328_light<<-sweep(peakIDm1_36f7_200328_light,2,c(xpeakID1max_36f7_200328_light,0))#最大値すなわちPeakから前後120sのデータでPeakを0sにする。
write.csv(peakIDm1_36f7_200328_light, "Kiss1-36f7_200328_light_peakID1.csv")

peakIDm1_36f7_200328_light_base<-subset(SEanalysisdata_36f7_200328_light, Time.s.>xpeakID1max_36f7_200328_light-240 & Time.s.<xpeakID1max_36f7_200328_light-120, c(Time.s.,Analog.In....Ch.2.AIn.2...Dem..AOut.2.))#最大値すなわちPeakから前240sから120sをbaselineに採用
peakIDm1_36f7_200328_light_f<-mean(peakIDm1_36f7_200328_light_base$Analog.In....Ch.2.AIn.2...Dem..AOut.2.)#Fbase平均の計算
peakIDm1_36f7_200328_light_dff<-(peakIDm1_36f7_200328_light$Analog.In....Ch.2.AIn.2...Dem..AOut.2.-peakIDm1_36f7_200328_light_f)/peakIDm1_36f7_200328_light_f#dF/Fの計算
names(peakIDm1_36f7_200328_light_dff)

peakIDm1_36f7_200328_light_dff <-data.frame(peakIDm1_36f7_200328_light$Time.s.,peakIDm1_36f7_200328_light_dff)
names(peakIDm1_36f7_200328_light_dff)

write.csv(peakIDm1_36f7_200328_light_dff, "Kiss1-36f7_200328_light_peakID1_dff.csv")

ypeakIDm1_36f7_200328_light_sd<-sd(peakIDm1_36f7_200328_light_base$Analog.In....Ch.2.AIn.2...Dem..AOut.2.)
ypeakIDm1_36f7_200328_light_Zscore<-(peakIDm1_36f7_200328_light$Analog.In....Ch.2.AIn.2...Dem..AOut.2.-peakIDm1_36f7_200328_light_f)/ypeakIDm1_36f7_200328_light_sd

peakIDm1_36f7_200328_light_Zscore <-data.frame(peakIDm1_36f7_200328_light$Time.s.,ypeakIDm1_36f7_200328_light_Zscore)
names(peakIDm1_36f7_200328_light_Zscore)

write.csv(peakIDm1_36f7_200328_light_Zscore, "Kiss1-36f7_200328_light_peakID1_Zscore.csv")

peakIDm1max_36f7_200328_light_dff<-(ypeakID1max_36f7_200328_light-peakIDm1_36f7_200328_light_f)/peakIDm1_36f7_200328_light_f#peakのdF/Fの計算
peakIDm1max_36f7_200328_light_dff


xID1_36f7_200328_light<-peakIDm1_36f7_200328_light_dff$peakIDm1_36f7_200328_light.Time.s.
yID1_36f7_200328_light<-peakIDm1_36f7_200328_light_dff$peakIDm1_36f7_200328_light_dff/peakIDm1max_36f7_200328_light_dff#max値で割ることによってNormalizeする→peakが1になる

png("Kiss1-36f7_200328_light_peakID1.png", width = 400, height = 300, bg="transparent")
#X軸、Y軸を表示します。
xmin=-120#X軸の最小値
xmax=+120#X軸の最大値
xint=30#X軸の間隔
ymin=-0.2#Y軸の最小値
ymax=1.2#Y軸の最大値
yint=0.2#Y軸の間隔
plot(xID1_36f7_200328_light,yID1_36f7_200328_light,type="l", pch=16, cex=1, lwd=1,las=1, bg="transparent", xlim=c(xmin, xmax), ylim=c(ymin, ymax),axes=FALSE,an=FALSE)
axis(2,at=seq(ymin, ymax,yint), tcl=0.3, mgp=c(1,0.5,0.5),lwd=2,las=1)
axis(1,at=seq(xmin, xmax, xint), labels=c("-120","-90","-60","-30","0","30","60","90","120"), tcl=0.3, mgp=c(0,0.3,0),lwd=2,las=1)

mtext("Normalized ∆F/F (%)", side=2, line=2.5, cex=1)
mtext("Time (sec)", side=1, line=1.5, cex=1)
dev.off()

#left, right edge, fwhm of pulse 
y_halfmax_peakID1_36f7_200328_light<-peakIDm1max_36f7_200328_light_dff/2
halfmax_peakID1_36f7_200328_light<- subset(peakIDm1_36f7_200328_light_dff,peakIDm1_36f7_200328_light_dff>y_halfmax_peakID1_36f7_200328_light, c(peakIDm1_36f7_200328_light.Time.s.,peakIDm1_36f7_200328_light_dff))

leftedge_halfmax_peakID1_36f7_200328_light<-subset(halfmax_peakID1_36f7_200328_light, peakIDm1_36f7_200328_light.Time.s.<0, c(peakIDm1_36f7_200328_light.Time.s.,peakIDm1_36f7_200328_light_dff))
leftedge_halfmax_peakID1_36f7_200328_light<-subset(leftedge_halfmax_peakID1_36f7_200328_light, peakIDm1_36f7_200328_light_dff == min(peakIDm1_36f7_200328_light_dff))
leftedge_halfmax_peakID1_36f7_200328_light
x_leftedge_halfmax_peakID1_36f7_200328_light<-leftedge_halfmax_peakID1_36f7_200328_light$peakIDm1_36f7_200328_light.Time.s.
x_leftedge_halfmax_peakID1_36f7_200328_light

rightedge_halfmax_peakID1_36f7_200328_light<-subset(halfmax_peakID1_36f7_200328_light, peakIDm1_36f7_200328_light.Time.s.>0, c(peakIDm1_36f7_200328_light.Time.s.,peakIDm1_36f7_200328_light_dff))
rightedge_halfmax_peakID1_36f7_200328_light<-subset(rightedge_halfmax_peakID1_36f7_200328_light, peakIDm1_36f7_200328_light_dff == min(peakIDm1_36f7_200328_light_dff))
rightedge_halfmax_peakID1_36f7_200328_light
x_rightedge_halfmax_peakID1_36f7_200328_light<-rightedge_halfmax_peakID1_36f7_200328_light$peakIDm1_36f7_200328_light.Time.s.
x_rightedge_halfmax_peakID1_36f7_200328_light

fwhm_peakID1_36f7_200328_light<-x_rightedge_halfmax_peakID1_36f7_200328_light-x_leftedge_halfmax_peakID1_36f7_200328_light
fwhm_peakID1_36f7_200328_light

y_thirdmax_peakID1_36f7_200328_light<-peakIDm1max_36f7_200328_light_dff/3
thirdmax_peakID1_36f7_200328_light<- subset(peakIDm1_36f7_200328_light_dff,peakIDm1_36f7_200328_light_dff>y_thirdmax_peakID1_36f7_200328_light, c(peakIDm1_36f7_200328_light.Time.s.,peakIDm1_36f7_200328_light_dff))

leftedge_thirdmax_peakID1_36f7_200328_light<-subset(thirdmax_peakID1_36f7_200328_light, peakIDm1_36f7_200328_light.Time.s.<0, c(peakIDm1_36f7_200328_light.Time.s.,peakIDm1_36f7_200328_light_dff))
leftedge_thirdmax_peakID1_36f7_200328_light<-subset(leftedge_thirdmax_peakID1_36f7_200328_light, peakIDm1_36f7_200328_light_dff == min(peakIDm1_36f7_200328_light_dff))
leftedge_thirdmax_peakID1_36f7_200328_light
x_leftedge_thirdmax_peakID1_36f7_200328_light<-leftedge_thirdmax_peakID1_36f7_200328_light$peakIDm1_36f7_200328_light.Time.s.
x_leftedge_thirdmax_peakID1_36f7_200328_light

rightedge_thirdmax_peakID1_36f7_200328_light<-subset(thirdmax_peakID1_36f7_200328_light, peakIDm1_36f7_200328_light.Time.s.>0, c(peakIDm1_36f7_200328_light.Time.s.,peakIDm1_36f7_200328_light_dff))
rightedge_thirdmax_peakID1_36f7_200328_light<-subset(rightedge_thirdmax_peakID1_36f7_200328_light, peakIDm1_36f7_200328_light_dff == min(peakIDm1_36f7_200328_light_dff))
rightedge_thirdmax_peakID1_36f7_200328_light
x_rightedge_thirdmax_peakID1_36f7_200328_light<-rightedge_thirdmax_peakID1_36f7_200328_light$peakIDm1_36f7_200328_light.Time.s.
x_rightedge_thirdmax_peakID1_36f7_200328_light

fw3rdm_peakID1_36f7_200328_light<-x_rightedge_thirdmax_peakID1_36f7_200328_light-x_leftedge_thirdmax_peakID1_36f7_200328_light
fw3rdm_peakID1_36f7_200328_light

y_fourthmax_peakID1_36f7_200328_light<-peakIDm1max_36f7_200328_light_dff/4
fourthmax_peakID1_36f7_200328_light<- subset(peakIDm1_36f7_200328_light_dff,peakIDm1_36f7_200328_light_dff>y_fourthmax_peakID1_36f7_200328_light, c(peakIDm1_36f7_200328_light.Time.s.,peakIDm1_36f7_200328_light_dff))

leftedge_fourthmax_peakID1_36f7_200328_light<-subset(fourthmax_peakID1_36f7_200328_light, peakIDm1_36f7_200328_light.Time.s.<0, c(peakIDm1_36f7_200328_light.Time.s.,peakIDm1_36f7_200328_light_dff))
leftedge_fourthmax_peakID1_36f7_200328_light<-subset(leftedge_fourthmax_peakID1_36f7_200328_light, peakIDm1_36f7_200328_light_dff == min(peakIDm1_36f7_200328_light_dff))
leftedge_fourthmax_peakID1_36f7_200328_light
x_leftedge_fourthmax_peakID1_36f7_200328_light<-leftedge_fourthmax_peakID1_36f7_200328_light$peakIDm1_36f7_200328_light.Time.s.
x_leftedge_fourthmax_peakID1_36f7_200328_light

rightedge_fourthmax_peakID1_36f7_200328_light<-subset(fourthmax_peakID1_36f7_200328_light, peakIDm1_36f7_200328_light.Time.s.>0, c(peakIDm1_36f7_200328_light.Time.s.,peakIDm1_36f7_200328_light_dff))
rightedge_fourthmax_peakID1_36f7_200328_light<-subset(rightedge_fourthmax_peakID1_36f7_200328_light, peakIDm1_36f7_200328_light_dff == min(peakIDm1_36f7_200328_light_dff))
rightedge_fourthmax_peakID1_36f7_200328_light
x_rightedge_fourthmax_peakID1_36f7_200328_light<-rightedge_fourthmax_peakID1_36f7_200328_light$peakIDm1_36f7_200328_light.Time.s.
x_rightedge_fourthmax_peakID1_36f7_200328_light

fw4thm_peakID1_36f7_200328_light<-x_rightedge_fourthmax_peakID1_36f7_200328_light-x_leftedge_fourthmax_peakID1_36f7_200328_light
fw4thm_peakID1_36f7_200328_light



#base analysis
#固定Pre:-110,-80,-50から-20秒、Post:30秒から60秒、90秒
left_base_peakIDm1_36f7_200328_light_30<-subset(peakIDm1_36f7_200328_light_dff, peakIDm1_36f7_200328_light.Time.s.>-50 & peakIDm1_36f7_200328_light.Time.s.< -20, c(peakIDm1_36f7_200328_light.Time.s.,peakIDm1_36f7_200328_light_dff))
ave_left_base_peakIDm1_36f7_200328_light_30<-mean(left_base_peakIDm1_36f7_200328_light_30$peakIDm1_36f7_200328_light_dff)
ave_left_base_peakIDm1_36f7_200328_light_30
SD_left_base_peakIDm1_36f7_200328_light_30<-sd(left_base_peakIDm1_36f7_200328_light_30$peakIDm1_36f7_200328_light_dff)
SD_left_base_peakIDm1_36f7_200328_light_30
CV_left_base_peakIDm1_36f7_200328_light_30<-SD_left_base_peakIDm1_36f7_200328_light_30/ave_left_base_peakIDm1_36f7_200328_light_30
CV_left_base_peakIDm1_36f7_200328_light_30

left_base_peakIDm1_36f7_200328_light_60<-subset(peakIDm1_36f7_200328_light_dff, peakIDm1_36f7_200328_light.Time.s.>-80 & peakIDm1_36f7_200328_light.Time.s.< -50, c(peakIDm1_36f7_200328_light.Time.s.,peakIDm1_36f7_200328_light_dff))
ave_left_base_peakIDm1_36f7_200328_light_60<-mean(left_base_peakIDm1_36f7_200328_light_60$peakIDm1_36f7_200328_light_dff)
ave_left_base_peakIDm1_36f7_200328_light_60
SD_left_base_peakIDm1_36f7_200328_light_60<-sd(left_base_peakIDm1_36f7_200328_light_60$peakIDm1_36f7_200328_light_dff)
SD_left_base_peakIDm1_36f7_200328_light_60
CV_left_base_peakIDm1_36f7_200328_light_60<-SD_left_base_peakIDm1_36f7_200328_light_60/ave_left_base_peakIDm1_36f7_200328_light_60
CV_left_base_peakIDm1_36f7_200328_light_60

left_base_peakIDm1_36f7_200328_light_90<-subset(peakIDm1_36f7_200328_light_dff, peakIDm1_36f7_200328_light.Time.s.>-110 & peakIDm1_36f7_200328_light.Time.s.< -80, c(peakIDm1_36f7_200328_light.Time.s.,peakIDm1_36f7_200328_light_dff))
ave_left_base_peakIDm1_36f7_200328_light_90<-mean(left_base_peakIDm1_36f7_200328_light_90$peakIDm1_36f7_200328_light_dff)
ave_left_base_peakIDm1_36f7_200328_light_90
SD_left_base_peakIDm1_36f7_200328_light_90<-sd(left_base_peakIDm1_36f7_200328_light_90$peakIDm1_36f7_200328_light_dff)
SD_left_base_peakIDm1_36f7_200328_light_90
CV_left_base_peakIDm1_36f7_200328_light_90<-SD_left_base_peakIDm1_36f7_200328_light_90/ave_left_base_peakIDm1_36f7_200328_light_90
CV_left_base_peakIDm1_36f7_200328_light_90

right_base_peakIDm1_36f7_200328_light_30<-subset(peakIDm1_36f7_200328_light_dff, peakIDm1_36f7_200328_light.Time.s.>-60 & peakIDm1_36f7_200328_light.Time.s.< -30, c(peakIDm1_36f7_200328_light.Time.s.,peakIDm1_36f7_200328_light_dff))
ave_right_base_peakIDm1_36f7_200328_light_30<-mean(right_base_peakIDm1_36f7_200328_light_30$peakIDm1_36f7_200328_light_dff)
ave_right_base_peakIDm1_36f7_200328_light_30
SD_right_base_peakIDm1_36f7_200328_light_30<-sd(right_base_peakIDm1_36f7_200328_light_30$peakIDm1_36f7_200328_light_dff)
SD_right_base_peakIDm1_36f7_200328_light_30
CV_right_base_peakIDm1_36f7_200328_light_30<-SD_right_base_peakIDm1_36f7_200328_light_30/ave_right_base_peakIDm1_36f7_200328_light_30
CV_right_base_peakIDm1_36f7_200328_light_30

right_base_peakIDm1_36f7_200328_light_60<-subset(peakIDm1_36f7_200328_light_dff, peakIDm1_36f7_200328_light.Time.s.>-90 & peakIDm1_36f7_200328_light.Time.s.< -60, c(peakIDm1_36f7_200328_light.Time.s.,peakIDm1_36f7_200328_light_dff))
ave_right_base_peakIDm1_36f7_200328_light_60<-mean(right_base_peakIDm1_36f7_200328_light_60$peakIDm1_36f7_200328_light_dff)
ave_right_base_peakIDm1_36f7_200328_light_60
SD_right_base_peakIDm1_36f7_200328_light_60<-sd(right_base_peakIDm1_36f7_200328_light_60$peakIDm1_36f7_200328_light_dff)
SD_right_base_peakIDm1_36f7_200328_light_60
CV_right_base_peakIDm1_36f7_200328_light_60<-SD_right_base_peakIDm1_36f7_200328_light_60/ave_right_base_peakIDm1_36f7_200328_light_60
CV_right_base_peakIDm1_36f7_200328_light_60

right_base_peakIDm1_36f7_200328_light_90<-subset(peakIDm1_36f7_200328_light_dff, peakIDm1_36f7_200328_light.Time.s.>-120 & peakIDm1_36f7_200328_light.Time.s.< -90, c(peakIDm1_36f7_200328_light.Time.s.,peakIDm1_36f7_200328_light_dff))
ave_right_base_peakIDm1_36f7_200328_light_90<-mean(right_base_peakIDm1_36f7_200328_light_90$peakIDm1_36f7_200328_light_dff)
ave_right_base_peakIDm1_36f7_200328_light_90
SD_right_base_peakIDm1_36f7_200328_light_90<-sd(right_base_peakIDm1_36f7_200328_light_90$peakIDm1_36f7_200328_light_dff)
SD_right_base_peakIDm1_36f7_200328_light_90
CV_right_base_peakIDm1_36f7_200328_light_90<-SD_right_base_peakIDm1_36f7_200328_light_90/ave_right_base_peakIDm1_36f7_200328_light_90
CV_right_base_peakIDm1_36f7_200328_light_90










peakID2_36f7_200328_light<-subset(SEanalysisdata_36f7_200328_light, Time.s.>2*3600 & Time.s.<2.5*3600, c(Time.s.,Analog.In....Ch.2.AIn.2...Dem..AOut.2.))#６h PNGファイルから目視でピーク前後の時間数を入力

peakID2max_36f7_200328_light<-subset(peakID2_36f7_200328_light, Analog.In....Ch.2.AIn.2...Dem..AOut.2. == max(Analog.In....Ch.2.AIn.2...Dem..AOut.2.))
peakID2max_36f7_200328_light#最大値すなわちPeakを見つけ出す

xpeakID2max_36f7_200328_light<-peakID2max_36f7_200328_light$Time.s.
xpeakID2max_36f7_200328_light#最大値すなわちPeakの時間を指定

xpeakID2maxh_36f7_200328_light<-xpeakID2max_36f7_200328_light/3600
xpeakID2maxh_36f7_200328_light#最大値すなわちPeakの時間を指定、時間表示なので、思ったものか６h PNGファイルで確認。

ypeakID2max_36f7_200328_light<-peakID2max_36f7_200328_light$Analog.In....Ch.2.AIn.2...Dem..AOut.2.
ypeakID2max_36f7_200328_light#最大値すなわちPeakのRaw値を指定

peakIDm2_36f7_200328_light<-subset(SEanalysisdata_36f7_200328_light, Time.s.>xpeakID2max_36f7_200328_light-120 & Time.s.<xpeakID2max_36f7_200328_light+120, c(Time.s.,Analog.In....Ch.2.AIn.2...Dem..AOut.2.))#最大値すなわちPeakから前後120sのデータだけひっぱてくる。
peakIDm2_36f7_200328_light<<-sweep(peakIDm2_36f7_200328_light,2,c(xpeakID2max_36f7_200328_light,0))#最大値すなわちPeakから前後120sのデータでPeakを0sにする。
write.csv(peakIDm2_36f7_200328_light, "Kiss1-36f7_200328_light_peakID2.csv")

peakIDm2_36f7_200328_light_base<-subset(SEanalysisdata_36f7_200328_light, Time.s.>xpeakID2max_36f7_200328_light-240 & Time.s.<xpeakID2max_36f7_200328_light-120, c(Time.s.,Analog.In....Ch.2.AIn.2...Dem..AOut.2.))#最大値すなわちPeakから前240sから120sをbaselineに採用
peakIDm2_36f7_200328_light_f<-mean(peakIDm2_36f7_200328_light_base$Analog.In....Ch.2.AIn.2...Dem..AOut.2.)#Fbase平均の計算
peakIDm2_36f7_200328_light_dff<-(peakIDm2_36f7_200328_light$Analog.In....Ch.2.AIn.2...Dem..AOut.2.-peakIDm2_36f7_200328_light_f)/peakIDm2_36f7_200328_light_f#dF/Fの計算
names(peakIDm2_36f7_200328_light_dff)

peakIDm2_36f7_200328_light_dff <-data.frame(peakIDm2_36f7_200328_light$Time.s.,peakIDm2_36f7_200328_light_dff)
names(peakIDm2_36f7_200328_light_dff)

write.csv(peakIDm2_36f7_200328_light_dff, "Kiss1-36f7_200328_light_peakID2_dff.csv")

ypeakIDm2_36f7_200328_light_sd<-sd(peakIDm2_36f7_200328_light_base$Analog.In....Ch.2.AIn.2...Dem..AOut.2.)
ypeakIDm2_36f7_200328_light_Zscore<-(peakIDm2_36f7_200328_light$Analog.In....Ch.2.AIn.2...Dem..AOut.2.-peakIDm2_36f7_200328_light_f)/ypeakIDm2_36f7_200328_light_sd

peakIDm2_36f7_200328_light_Zscore <-data.frame(peakIDm2_36f7_200328_light$Time.s.,ypeakIDm2_36f7_200328_light_Zscore)
names(peakIDm2_36f7_200328_light_Zscore)

write.csv(peakIDm2_36f7_200328_light_Zscore, "Kiss1-36f7_200328_light_peakID2_Zscore.csv")

peakIDm2max_36f7_200328_light_dff<-(ypeakID2max_36f7_200328_light-peakIDm2_36f7_200328_light_f)/peakIDm2_36f7_200328_light_f#peakのdF/Fの計算
peakIDm2max_36f7_200328_light_dff


xID2_36f7_200328_light<-peakIDm2_36f7_200328_light_dff$peakIDm2_36f7_200328_light.Time.s.
yID2_36f7_200328_light<-peakIDm2_36f7_200328_light_dff$peakIDm2_36f7_200328_light_dff/peakIDm2max_36f7_200328_light_dff#max値で割ることによってNormalizeする→peakが1になる

png("Kiss1-36f7_200328_light_peakID2.png", width = 400, height = 300, bg="transparent")
#X軸、Y軸を表示します。
xmin=-120#X軸の最小値
xmax=+120#X軸の最大値
xint=30#X軸の間隔
ymin=-0.2#Y軸の最小値
ymax=1.2#Y軸の最大値
yint=0.2#Y軸の間隔
plot(xID2_36f7_200328_light,yID2_36f7_200328_light,type="l", pch=16, cex=1, lwd=1,las=1, bg="transparent", xlim=c(xmin, xmax), ylim=c(ymin, ymax),axes=FALSE,an=FALSE)
axis(2,at=seq(ymin, ymax,yint), tcl=0.3, mgp=c(1,0.5,0.5),lwd=2,las=1)
axis(1,at=seq(xmin, xmax, xint), labels=c("-120","-90","-60","-30","0","30","60","90","120"), tcl=0.3, mgp=c(0,0.3,0),lwd=2,las=1)

mtext("Normalized ∆F/F (%)", side=2, line=2.5, cex=1)
mtext("Time (sec)", side=1, line=1.5, cex=1)
dev.off()

#left, right edge, fwhm of pulse 
y_halfmax_peakID2_36f7_200328_light<-peakIDm2max_36f7_200328_light_dff/2
halfmax_peakID2_36f7_200328_light<- subset(peakIDm2_36f7_200328_light_dff,peakIDm2_36f7_200328_light_dff>y_halfmax_peakID2_36f7_200328_light, c(peakIDm2_36f7_200328_light.Time.s.,peakIDm2_36f7_200328_light_dff))

leftedge_halfmax_peakID2_36f7_200328_light<-subset(halfmax_peakID2_36f7_200328_light, peakIDm2_36f7_200328_light.Time.s.<0, c(peakIDm2_36f7_200328_light.Time.s.,peakIDm2_36f7_200328_light_dff))
leftedge_halfmax_peakID2_36f7_200328_light<-subset(leftedge_halfmax_peakID2_36f7_200328_light, peakIDm2_36f7_200328_light_dff == min(peakIDm2_36f7_200328_light_dff))
leftedge_halfmax_peakID2_36f7_200328_light
x_leftedge_halfmax_peakID2_36f7_200328_light<-leftedge_halfmax_peakID2_36f7_200328_light$peakIDm2_36f7_200328_light.Time.s.
x_leftedge_halfmax_peakID2_36f7_200328_light

rightedge_halfmax_peakID2_36f7_200328_light<-subset(halfmax_peakID2_36f7_200328_light, peakIDm2_36f7_200328_light.Time.s.>0, c(peakIDm2_36f7_200328_light.Time.s.,peakIDm2_36f7_200328_light_dff))
rightedge_halfmax_peakID2_36f7_200328_light<-subset(rightedge_halfmax_peakID2_36f7_200328_light, peakIDm2_36f7_200328_light_dff == min(peakIDm2_36f7_200328_light_dff))
rightedge_halfmax_peakID2_36f7_200328_light
x_rightedge_halfmax_peakID2_36f7_200328_light<-rightedge_halfmax_peakID2_36f7_200328_light$peakIDm2_36f7_200328_light.Time.s.
x_rightedge_halfmax_peakID2_36f7_200328_light

fwhm_peakID2_36f7_200328_light<-x_rightedge_halfmax_peakID2_36f7_200328_light-x_leftedge_halfmax_peakID2_36f7_200328_light
fwhm_peakID2_36f7_200328_light

y_thirdmax_peakID2_36f7_200328_light<-peakIDm2max_36f7_200328_light_dff/3
thirdmax_peakID2_36f7_200328_light<- subset(peakIDm2_36f7_200328_light_dff,peakIDm2_36f7_200328_light_dff>y_thirdmax_peakID2_36f7_200328_light, c(peakIDm2_36f7_200328_light.Time.s.,peakIDm2_36f7_200328_light_dff))

leftedge_thirdmax_peakID2_36f7_200328_light<-subset(thirdmax_peakID2_36f7_200328_light, peakIDm2_36f7_200328_light.Time.s.<0, c(peakIDm2_36f7_200328_light.Time.s.,peakIDm2_36f7_200328_light_dff))
leftedge_thirdmax_peakID2_36f7_200328_light<-subset(leftedge_thirdmax_peakID2_36f7_200328_light, peakIDm2_36f7_200328_light_dff == min(peakIDm2_36f7_200328_light_dff))
leftedge_thirdmax_peakID2_36f7_200328_light
x_leftedge_thirdmax_peakID2_36f7_200328_light<-leftedge_thirdmax_peakID2_36f7_200328_light$peakIDm2_36f7_200328_light.Time.s.
x_leftedge_thirdmax_peakID2_36f7_200328_light

rightedge_thirdmax_peakID2_36f7_200328_light<-subset(thirdmax_peakID2_36f7_200328_light, peakIDm2_36f7_200328_light.Time.s.>0, c(peakIDm2_36f7_200328_light.Time.s.,peakIDm2_36f7_200328_light_dff))
rightedge_thirdmax_peakID2_36f7_200328_light<-subset(rightedge_thirdmax_peakID2_36f7_200328_light, peakIDm2_36f7_200328_light_dff == min(peakIDm2_36f7_200328_light_dff))
rightedge_thirdmax_peakID2_36f7_200328_light
x_rightedge_thirdmax_peakID2_36f7_200328_light<-rightedge_thirdmax_peakID2_36f7_200328_light$peakIDm2_36f7_200328_light.Time.s.
x_rightedge_thirdmax_peakID2_36f7_200328_light

fw3rdm_peakID2_36f7_200328_light<-x_rightedge_thirdmax_peakID2_36f7_200328_light-x_leftedge_thirdmax_peakID2_36f7_200328_light
fw3rdm_peakID2_36f7_200328_light

y_fourthmax_peakID2_36f7_200328_light<-peakIDm2max_36f7_200328_light_dff/4
fourthmax_peakID2_36f7_200328_light<- subset(peakIDm2_36f7_200328_light_dff,peakIDm2_36f7_200328_light_dff>y_fourthmax_peakID2_36f7_200328_light, c(peakIDm2_36f7_200328_light.Time.s.,peakIDm2_36f7_200328_light_dff))

leftedge_fourthmax_peakID2_36f7_200328_light<-subset(fourthmax_peakID2_36f7_200328_light, peakIDm2_36f7_200328_light.Time.s.<0, c(peakIDm2_36f7_200328_light.Time.s.,peakIDm2_36f7_200328_light_dff))
leftedge_fourthmax_peakID2_36f7_200328_light<-subset(leftedge_fourthmax_peakID2_36f7_200328_light, peakIDm2_36f7_200328_light_dff == min(peakIDm2_36f7_200328_light_dff))
leftedge_fourthmax_peakID2_36f7_200328_light
x_leftedge_fourthmax_peakID2_36f7_200328_light<-leftedge_fourthmax_peakID2_36f7_200328_light$peakIDm2_36f7_200328_light.Time.s.
x_leftedge_fourthmax_peakID2_36f7_200328_light

rightedge_fourthmax_peakID2_36f7_200328_light<-subset(fourthmax_peakID2_36f7_200328_light, peakIDm2_36f7_200328_light.Time.s.>0, c(peakIDm2_36f7_200328_light.Time.s.,peakIDm2_36f7_200328_light_dff))
rightedge_fourthmax_peakID2_36f7_200328_light<-subset(rightedge_fourthmax_peakID2_36f7_200328_light, peakIDm2_36f7_200328_light_dff == min(peakIDm2_36f7_200328_light_dff))
rightedge_fourthmax_peakID2_36f7_200328_light
x_rightedge_fourthmax_peakID2_36f7_200328_light<-rightedge_fourthmax_peakID2_36f7_200328_light$peakIDm2_36f7_200328_light.Time.s.
x_rightedge_fourthmax_peakID2_36f7_200328_light

fw4thm_peakID2_36f7_200328_light<-x_rightedge_fourthmax_peakID2_36f7_200328_light-x_leftedge_fourthmax_peakID2_36f7_200328_light
fw4thm_peakID2_36f7_200328_light



#base analysis
#固定Pre:-110,-80,-50から-20秒、Post:30秒から60秒、90秒
left_base_peakIDm2_36f7_200328_light_30<-subset(peakIDm2_36f7_200328_light_dff, peakIDm2_36f7_200328_light.Time.s.>-50 & peakIDm2_36f7_200328_light.Time.s.< -20, c(peakIDm2_36f7_200328_light.Time.s.,peakIDm2_36f7_200328_light_dff))
ave_left_base_peakIDm2_36f7_200328_light_30<-mean(left_base_peakIDm2_36f7_200328_light_30$peakIDm2_36f7_200328_light_dff)
ave_left_base_peakIDm2_36f7_200328_light_30
SD_left_base_peakIDm2_36f7_200328_light_30<-sd(left_base_peakIDm2_36f7_200328_light_30$peakIDm2_36f7_200328_light_dff)
SD_left_base_peakIDm2_36f7_200328_light_30
CV_left_base_peakIDm2_36f7_200328_light_30<-SD_left_base_peakIDm2_36f7_200328_light_30/ave_left_base_peakIDm2_36f7_200328_light_30
CV_left_base_peakIDm2_36f7_200328_light_30

left_base_peakIDm2_36f7_200328_light_60<-subset(peakIDm2_36f7_200328_light_dff, peakIDm2_36f7_200328_light.Time.s.>-80 & peakIDm2_36f7_200328_light.Time.s.< -50, c(peakIDm2_36f7_200328_light.Time.s.,peakIDm2_36f7_200328_light_dff))
ave_left_base_peakIDm2_36f7_200328_light_60<-mean(left_base_peakIDm2_36f7_200328_light_60$peakIDm2_36f7_200328_light_dff)
ave_left_base_peakIDm2_36f7_200328_light_60
SD_left_base_peakIDm2_36f7_200328_light_60<-sd(left_base_peakIDm2_36f7_200328_light_60$peakIDm2_36f7_200328_light_dff)
SD_left_base_peakIDm2_36f7_200328_light_60
CV_left_base_peakIDm2_36f7_200328_light_60<-SD_left_base_peakIDm2_36f7_200328_light_60/ave_left_base_peakIDm2_36f7_200328_light_60
CV_left_base_peakIDm2_36f7_200328_light_60

left_base_peakIDm2_36f7_200328_light_90<-subset(peakIDm2_36f7_200328_light_dff, peakIDm2_36f7_200328_light.Time.s.>-110 & peakIDm2_36f7_200328_light.Time.s.< -80, c(peakIDm2_36f7_200328_light.Time.s.,peakIDm2_36f7_200328_light_dff))
ave_left_base_peakIDm2_36f7_200328_light_90<-mean(left_base_peakIDm2_36f7_200328_light_90$peakIDm2_36f7_200328_light_dff)
ave_left_base_peakIDm2_36f7_200328_light_90
SD_left_base_peakIDm2_36f7_200328_light_90<-sd(left_base_peakIDm2_36f7_200328_light_90$peakIDm2_36f7_200328_light_dff)
SD_left_base_peakIDm2_36f7_200328_light_90
CV_left_base_peakIDm2_36f7_200328_light_90<-SD_left_base_peakIDm2_36f7_200328_light_90/ave_left_base_peakIDm2_36f7_200328_light_90
CV_left_base_peakIDm2_36f7_200328_light_90

right_base_peakIDm2_36f7_200328_light_30<-subset(peakIDm2_36f7_200328_light_dff, peakIDm2_36f7_200328_light.Time.s.>-60 & peakIDm2_36f7_200328_light.Time.s.< -30, c(peakIDm2_36f7_200328_light.Time.s.,peakIDm2_36f7_200328_light_dff))
ave_right_base_peakIDm2_36f7_200328_light_30<-mean(right_base_peakIDm2_36f7_200328_light_30$peakIDm2_36f7_200328_light_dff)
ave_right_base_peakIDm2_36f7_200328_light_30
SD_right_base_peakIDm2_36f7_200328_light_30<-sd(right_base_peakIDm2_36f7_200328_light_30$peakIDm2_36f7_200328_light_dff)
SD_right_base_peakIDm2_36f7_200328_light_30
CV_right_base_peakIDm2_36f7_200328_light_30<-SD_right_base_peakIDm2_36f7_200328_light_30/ave_right_base_peakIDm2_36f7_200328_light_30
CV_right_base_peakIDm2_36f7_200328_light_30

right_base_peakIDm2_36f7_200328_light_60<-subset(peakIDm2_36f7_200328_light_dff, peakIDm2_36f7_200328_light.Time.s.>-90 & peakIDm2_36f7_200328_light.Time.s.< -60, c(peakIDm2_36f7_200328_light.Time.s.,peakIDm2_36f7_200328_light_dff))
ave_right_base_peakIDm2_36f7_200328_light_60<-mean(right_base_peakIDm2_36f7_200328_light_60$peakIDm2_36f7_200328_light_dff)
ave_right_base_peakIDm2_36f7_200328_light_60
SD_right_base_peakIDm2_36f7_200328_light_60<-sd(right_base_peakIDm2_36f7_200328_light_60$peakIDm2_36f7_200328_light_dff)
SD_right_base_peakIDm2_36f7_200328_light_60
CV_right_base_peakIDm2_36f7_200328_light_60<-SD_right_base_peakIDm2_36f7_200328_light_60/ave_right_base_peakIDm2_36f7_200328_light_60
CV_right_base_peakIDm2_36f7_200328_light_60

right_base_peakIDm2_36f7_200328_light_90<-subset(peakIDm2_36f7_200328_light_dff, peakIDm2_36f7_200328_light.Time.s.>-120 & peakIDm2_36f7_200328_light.Time.s.< -90, c(peakIDm2_36f7_200328_light.Time.s.,peakIDm2_36f7_200328_light_dff))
ave_right_base_peakIDm2_36f7_200328_light_90<-mean(right_base_peakIDm2_36f7_200328_light_90$peakIDm2_36f7_200328_light_dff)
ave_right_base_peakIDm2_36f7_200328_light_90
SD_right_base_peakIDm2_36f7_200328_light_90<-sd(right_base_peakIDm2_36f7_200328_light_90$peakIDm2_36f7_200328_light_dff)
SD_right_base_peakIDm2_36f7_200328_light_90
CV_right_base_peakIDm2_36f7_200328_light_90<-SD_right_base_peakIDm2_36f7_200328_light_90/ave_right_base_peakIDm2_36f7_200328_light_90
CV_right_base_peakIDm2_36f7_200328_light_90





peakID3_36f7_200328_light<-subset(SEanalysisdata_36f7_200328_light, Time.s.>3*3600 & Time.s.<3.5*3600, c(Time.s.,Analog.In....Ch.2.AIn.2...Dem..AOut.2.))#６h PNGファイルから目視でピーク前後の時間数を入力

peakID3max_36f7_200328_light<-subset(peakID3_36f7_200328_light, Analog.In....Ch.2.AIn.2...Dem..AOut.2. == max(Analog.In....Ch.2.AIn.2...Dem..AOut.2.))
peakID3max_36f7_200328_light#最大値すなわちPeakを見つけ出す

xpeakID3max_36f7_200328_light<-peakID3max_36f7_200328_light$Time.s.
xpeakID3max_36f7_200328_light#最大値すなわちPeakの時間を指定

xpeakID3maxh_36f7_200328_light<-xpeakID3max_36f7_200328_light/3600
xpeakID3maxh_36f7_200328_light#最大値すなわちPeakの時間を指定、時間表示なので、思ったものか６h PNGファイルで確認。

ypeakID3max_36f7_200328_light<-peakID3max_36f7_200328_light$Analog.In....Ch.2.AIn.2...Dem..AOut.2.
ypeakID3max_36f7_200328_light#最大値すなわちPeakのRaw値を指定

peakIDm3_36f7_200328_light<-subset(SEanalysisdata_36f7_200328_light, Time.s.>xpeakID3max_36f7_200328_light-120 & Time.s.<xpeakID3max_36f7_200328_light+120, c(Time.s.,Analog.In....Ch.2.AIn.2...Dem..AOut.2.))#最大値すなわちPeakから前後120sのデータだけひっぱてくる。
peakIDm3_36f7_200328_light<<-sweep(peakIDm3_36f7_200328_light,2,c(xpeakID3max_36f7_200328_light,0))#最大値すなわちPeakから前後120sのデータでPeakを0sにする。
write.csv(peakIDm3_36f7_200328_light, "Kiss1-36f7_200328_light_peakID3.csv")

peakIDm3_36f7_200328_light_base<-subset(SEanalysisdata_36f7_200328_light, Time.s.>xpeakID3max_36f7_200328_light-240 & Time.s.<xpeakID3max_36f7_200328_light-120, c(Time.s.,Analog.In....Ch.2.AIn.2...Dem..AOut.2.))#最大値すなわちPeakから前240sから120sをbaselineに採用
peakIDm3_36f7_200328_light_f<-mean(peakIDm3_36f7_200328_light_base$Analog.In....Ch.2.AIn.2...Dem..AOut.2.)#Fbase平均の計算
peakIDm3_36f7_200328_light_dff<-(peakIDm3_36f7_200328_light$Analog.In....Ch.2.AIn.2...Dem..AOut.2.-peakIDm3_36f7_200328_light_f)/peakIDm3_36f7_200328_light_f#dF/Fの計算
names(peakIDm3_36f7_200328_light_dff)

peakIDm3_36f7_200328_light_dff <-data.frame(peakIDm3_36f7_200328_light$Time.s.,peakIDm3_36f7_200328_light_dff)
names(peakIDm3_36f7_200328_light_dff)

write.csv(peakIDm3_36f7_200328_light_dff, "Kiss1-36f7_200328_light_peakID3_dff.csv")

ypeakIDm3_36f7_200328_light_sd<-sd(peakIDm3_36f7_200328_light_base$Analog.In....Ch.2.AIn.2...Dem..AOut.2.)
ypeakIDm3_36f7_200328_light_Zscore<-(peakIDm3_36f7_200328_light$Analog.In....Ch.2.AIn.2...Dem..AOut.2.-peakIDm3_36f7_200328_light_f)/ypeakIDm3_36f7_200328_light_sd

peakIDm3_36f7_200328_light_Zscore <-data.frame(peakIDm3_36f7_200328_light$Time.s.,ypeakIDm3_36f7_200328_light_Zscore)
names(peakIDm3_36f7_200328_light_Zscore)

write.csv(peakIDm3_36f7_200328_light_Zscore, "Kiss1-36f7_200328_light_peakID3_Zscore.csv")

peakIDm3max_36f7_200328_light_dff<-(ypeakID3max_36f7_200328_light-peakIDm3_36f7_200328_light_f)/peakIDm3_36f7_200328_light_f#peakのdF/Fの計算
peakIDm3max_36f7_200328_light_dff


xID3_36f7_200328_light<-peakIDm3_36f7_200328_light_dff$peakIDm3_36f7_200328_light.Time.s.
yID3_36f7_200328_light<-peakIDm3_36f7_200328_light_dff$peakIDm3_36f7_200328_light_dff/peakIDm3max_36f7_200328_light_dff#max値で割ることによってNormalizeする→peakが1になる

png("Kiss1-36f7_200328_light_peakID3.png", width = 400, height = 300, bg="transparent")
#X軸、Y軸を表示します。
xmin=-120#X軸の最小値
xmax=+120#X軸の最大値
xint=30#X軸の間隔
ymin=-0.2#Y軸の最小値
ymax=1.2#Y軸の最大値
yint=0.2#Y軸の間隔
plot(xID3_36f7_200328_light,yID3_36f7_200328_light,type="l", pch=16, cex=1, lwd=1,las=1, bg="transparent", xlim=c(xmin, xmax), ylim=c(ymin, ymax),axes=FALSE,an=FALSE)
axis(2,at=seq(ymin, ymax,yint), tcl=0.3, mgp=c(1,0.5,0.5),lwd=2,las=1)
axis(1,at=seq(xmin, xmax, xint), labels=c("-120","-90","-60","-30","0","30","60","90","120"), tcl=0.3, mgp=c(0,0.3,0),lwd=2,las=1)

mtext("Normalized ∆F/F (%)", side=2, line=2.5, cex=1)
mtext("Time (sec)", side=1, line=1.5, cex=1)
dev.off()

#left, right edge, fwhm of pulse 
y_halfmax_peakID3_36f7_200328_light<-peakIDm3max_36f7_200328_light_dff/2
halfmax_peakID3_36f7_200328_light<- subset(peakIDm3_36f7_200328_light_dff,peakIDm3_36f7_200328_light_dff>y_halfmax_peakID3_36f7_200328_light, c(peakIDm3_36f7_200328_light.Time.s.,peakIDm3_36f7_200328_light_dff))

leftedge_halfmax_peakID3_36f7_200328_light<-subset(halfmax_peakID3_36f7_200328_light, peakIDm3_36f7_200328_light.Time.s.<0, c(peakIDm3_36f7_200328_light.Time.s.,peakIDm3_36f7_200328_light_dff))
leftedge_halfmax_peakID3_36f7_200328_light<-subset(leftedge_halfmax_peakID3_36f7_200328_light, peakIDm3_36f7_200328_light_dff == min(peakIDm3_36f7_200328_light_dff))
leftedge_halfmax_peakID3_36f7_200328_light
x_leftedge_halfmax_peakID3_36f7_200328_light<-leftedge_halfmax_peakID3_36f7_200328_light$peakIDm3_36f7_200328_light.Time.s.
x_leftedge_halfmax_peakID3_36f7_200328_light

rightedge_halfmax_peakID3_36f7_200328_light<-subset(halfmax_peakID3_36f7_200328_light, peakIDm3_36f7_200328_light.Time.s.>0, c(peakIDm3_36f7_200328_light.Time.s.,peakIDm3_36f7_200328_light_dff))
rightedge_halfmax_peakID3_36f7_200328_light<-subset(rightedge_halfmax_peakID3_36f7_200328_light, peakIDm3_36f7_200328_light_dff == min(peakIDm3_36f7_200328_light_dff))
rightedge_halfmax_peakID3_36f7_200328_light
x_rightedge_halfmax_peakID3_36f7_200328_light<-rightedge_halfmax_peakID3_36f7_200328_light$peakIDm3_36f7_200328_light.Time.s.
x_rightedge_halfmax_peakID3_36f7_200328_light

fwhm_peakID3_36f7_200328_light<-x_rightedge_halfmax_peakID3_36f7_200328_light-x_leftedge_halfmax_peakID3_36f7_200328_light
fwhm_peakID3_36f7_200328_light

y_thirdmax_peakID3_36f7_200328_light<-peakIDm3max_36f7_200328_light_dff/3
thirdmax_peakID3_36f7_200328_light<- subset(peakIDm3_36f7_200328_light_dff,peakIDm3_36f7_200328_light_dff>y_thirdmax_peakID3_36f7_200328_light, c(peakIDm3_36f7_200328_light.Time.s.,peakIDm3_36f7_200328_light_dff))

leftedge_thirdmax_peakID3_36f7_200328_light<-subset(thirdmax_peakID3_36f7_200328_light, peakIDm3_36f7_200328_light.Time.s.<0, c(peakIDm3_36f7_200328_light.Time.s.,peakIDm3_36f7_200328_light_dff))
leftedge_thirdmax_peakID3_36f7_200328_light<-subset(leftedge_thirdmax_peakID3_36f7_200328_light, peakIDm3_36f7_200328_light_dff == min(peakIDm3_36f7_200328_light_dff))
leftedge_thirdmax_peakID3_36f7_200328_light
x_leftedge_thirdmax_peakID3_36f7_200328_light<-leftedge_thirdmax_peakID3_36f7_200328_light$peakIDm3_36f7_200328_light.Time.s.
x_leftedge_thirdmax_peakID3_36f7_200328_light

rightedge_thirdmax_peakID3_36f7_200328_light<-subset(thirdmax_peakID3_36f7_200328_light, peakIDm3_36f7_200328_light.Time.s.>0, c(peakIDm3_36f7_200328_light.Time.s.,peakIDm3_36f7_200328_light_dff))
rightedge_thirdmax_peakID3_36f7_200328_light<-subset(rightedge_thirdmax_peakID3_36f7_200328_light, peakIDm3_36f7_200328_light_dff == min(peakIDm3_36f7_200328_light_dff))
rightedge_thirdmax_peakID3_36f7_200328_light
x_rightedge_thirdmax_peakID3_36f7_200328_light<-rightedge_thirdmax_peakID3_36f7_200328_light$peakIDm3_36f7_200328_light.Time.s.
x_rightedge_thirdmax_peakID3_36f7_200328_light

fw3rdm_peakID3_36f7_200328_light<-x_rightedge_thirdmax_peakID3_36f7_200328_light-x_leftedge_thirdmax_peakID3_36f7_200328_light
fw3rdm_peakID3_36f7_200328_light

y_fourthmax_peakID3_36f7_200328_light<-peakIDm3max_36f7_200328_light_dff/4
fourthmax_peakID3_36f7_200328_light<- subset(peakIDm3_36f7_200328_light_dff,peakIDm3_36f7_200328_light_dff>y_fourthmax_peakID3_36f7_200328_light, c(peakIDm3_36f7_200328_light.Time.s.,peakIDm3_36f7_200328_light_dff))

leftedge_fourthmax_peakID3_36f7_200328_light<-subset(fourthmax_peakID3_36f7_200328_light, peakIDm3_36f7_200328_light.Time.s.<0, c(peakIDm3_36f7_200328_light.Time.s.,peakIDm3_36f7_200328_light_dff))
leftedge_fourthmax_peakID3_36f7_200328_light<-subset(leftedge_fourthmax_peakID3_36f7_200328_light, peakIDm3_36f7_200328_light_dff == min(peakIDm3_36f7_200328_light_dff))
leftedge_fourthmax_peakID3_36f7_200328_light
x_leftedge_fourthmax_peakID3_36f7_200328_light<-leftedge_fourthmax_peakID3_36f7_200328_light$peakIDm3_36f7_200328_light.Time.s.
x_leftedge_fourthmax_peakID3_36f7_200328_light

rightedge_fourthmax_peakID3_36f7_200328_light<-subset(fourthmax_peakID3_36f7_200328_light, peakIDm3_36f7_200328_light.Time.s.>0, c(peakIDm3_36f7_200328_light.Time.s.,peakIDm3_36f7_200328_light_dff))
rightedge_fourthmax_peakID3_36f7_200328_light<-subset(rightedge_fourthmax_peakID3_36f7_200328_light, peakIDm3_36f7_200328_light_dff == min(peakIDm3_36f7_200328_light_dff))
rightedge_fourthmax_peakID3_36f7_200328_light
x_rightedge_fourthmax_peakID3_36f7_200328_light<-rightedge_fourthmax_peakID3_36f7_200328_light$peakIDm3_36f7_200328_light.Time.s.
x_rightedge_fourthmax_peakID3_36f7_200328_light

fw4thm_peakID3_36f7_200328_light<-x_rightedge_fourthmax_peakID3_36f7_200328_light-x_leftedge_fourthmax_peakID3_36f7_200328_light
fw4thm_peakID3_36f7_200328_light



#base analysis
#固定Pre:-110,-80,-50から-20秒、Post:30秒から60秒、90秒
left_base_peakIDm3_36f7_200328_light_30<-subset(peakIDm3_36f7_200328_light_dff, peakIDm3_36f7_200328_light.Time.s.>-50 & peakIDm3_36f7_200328_light.Time.s.< -20, c(peakIDm3_36f7_200328_light.Time.s.,peakIDm3_36f7_200328_light_dff))
ave_left_base_peakIDm3_36f7_200328_light_30<-mean(left_base_peakIDm3_36f7_200328_light_30$peakIDm3_36f7_200328_light_dff)
ave_left_base_peakIDm3_36f7_200328_light_30
SD_left_base_peakIDm3_36f7_200328_light_30<-sd(left_base_peakIDm3_36f7_200328_light_30$peakIDm3_36f7_200328_light_dff)
SD_left_base_peakIDm3_36f7_200328_light_30
CV_left_base_peakIDm3_36f7_200328_light_30<-SD_left_base_peakIDm3_36f7_200328_light_30/ave_left_base_peakIDm3_36f7_200328_light_30
CV_left_base_peakIDm3_36f7_200328_light_30

left_base_peakIDm3_36f7_200328_light_60<-subset(peakIDm3_36f7_200328_light_dff, peakIDm3_36f7_200328_light.Time.s.>-80 & peakIDm3_36f7_200328_light.Time.s.< -50, c(peakIDm3_36f7_200328_light.Time.s.,peakIDm3_36f7_200328_light_dff))
ave_left_base_peakIDm3_36f7_200328_light_60<-mean(left_base_peakIDm3_36f7_200328_light_60$peakIDm3_36f7_200328_light_dff)
ave_left_base_peakIDm3_36f7_200328_light_60
SD_left_base_peakIDm3_36f7_200328_light_60<-sd(left_base_peakIDm3_36f7_200328_light_60$peakIDm3_36f7_200328_light_dff)
SD_left_base_peakIDm3_36f7_200328_light_60
CV_left_base_peakIDm3_36f7_200328_light_60<-SD_left_base_peakIDm3_36f7_200328_light_60/ave_left_base_peakIDm3_36f7_200328_light_60
CV_left_base_peakIDm3_36f7_200328_light_60

left_base_peakIDm3_36f7_200328_light_90<-subset(peakIDm3_36f7_200328_light_dff, peakIDm3_36f7_200328_light.Time.s.>-110 & peakIDm3_36f7_200328_light.Time.s.< -80, c(peakIDm3_36f7_200328_light.Time.s.,peakIDm3_36f7_200328_light_dff))
ave_left_base_peakIDm3_36f7_200328_light_90<-mean(left_base_peakIDm3_36f7_200328_light_90$peakIDm3_36f7_200328_light_dff)
ave_left_base_peakIDm3_36f7_200328_light_90
SD_left_base_peakIDm3_36f7_200328_light_90<-sd(left_base_peakIDm3_36f7_200328_light_90$peakIDm3_36f7_200328_light_dff)
SD_left_base_peakIDm3_36f7_200328_light_90
CV_left_base_peakIDm3_36f7_200328_light_90<-SD_left_base_peakIDm3_36f7_200328_light_90/ave_left_base_peakIDm3_36f7_200328_light_90
CV_left_base_peakIDm3_36f7_200328_light_90

right_base_peakIDm3_36f7_200328_light_30<-subset(peakIDm3_36f7_200328_light_dff, peakIDm3_36f7_200328_light.Time.s.>-60 & peakIDm3_36f7_200328_light.Time.s.< -30, c(peakIDm3_36f7_200328_light.Time.s.,peakIDm3_36f7_200328_light_dff))
ave_right_base_peakIDm3_36f7_200328_light_30<-mean(right_base_peakIDm3_36f7_200328_light_30$peakIDm3_36f7_200328_light_dff)
ave_right_base_peakIDm3_36f7_200328_light_30
SD_right_base_peakIDm3_36f7_200328_light_30<-sd(right_base_peakIDm3_36f7_200328_light_30$peakIDm3_36f7_200328_light_dff)
SD_right_base_peakIDm3_36f7_200328_light_30
CV_right_base_peakIDm3_36f7_200328_light_30<-SD_right_base_peakIDm3_36f7_200328_light_30/ave_right_base_peakIDm3_36f7_200328_light_30
CV_right_base_peakIDm3_36f7_200328_light_30

right_base_peakIDm3_36f7_200328_light_60<-subset(peakIDm3_36f7_200328_light_dff, peakIDm3_36f7_200328_light.Time.s.>-90 & peakIDm3_36f7_200328_light.Time.s.< -60, c(peakIDm3_36f7_200328_light.Time.s.,peakIDm3_36f7_200328_light_dff))
ave_right_base_peakIDm3_36f7_200328_light_60<-mean(right_base_peakIDm3_36f7_200328_light_60$peakIDm3_36f7_200328_light_dff)
ave_right_base_peakIDm3_36f7_200328_light_60
SD_right_base_peakIDm3_36f7_200328_light_60<-sd(right_base_peakIDm3_36f7_200328_light_60$peakIDm3_36f7_200328_light_dff)
SD_right_base_peakIDm3_36f7_200328_light_60
CV_right_base_peakIDm3_36f7_200328_light_60<-SD_right_base_peakIDm3_36f7_200328_light_60/ave_right_base_peakIDm3_36f7_200328_light_60
CV_right_base_peakIDm3_36f7_200328_light_60

right_base_peakIDm3_36f7_200328_light_90<-subset(peakIDm3_36f7_200328_light_dff, peakIDm3_36f7_200328_light.Time.s.>-120 & peakIDm3_36f7_200328_light.Time.s.< -90, c(peakIDm3_36f7_200328_light.Time.s.,peakIDm3_36f7_200328_light_dff))
ave_right_base_peakIDm3_36f7_200328_light_90<-mean(right_base_peakIDm3_36f7_200328_light_90$peakIDm3_36f7_200328_light_dff)
ave_right_base_peakIDm3_36f7_200328_light_90
SD_right_base_peakIDm3_36f7_200328_light_90<-sd(right_base_peakIDm3_36f7_200328_light_90$peakIDm3_36f7_200328_light_dff)
SD_right_base_peakIDm3_36f7_200328_light_90
CV_right_base_peakIDm3_36f7_200328_light_90<-SD_right_base_peakIDm3_36f7_200328_light_90/ave_right_base_peakIDm3_36f7_200328_light_90
CV_right_base_peakIDm3_36f7_200328_light_90






peakID4_36f7_200328_light<-subset(SEanalysisdata_36f7_200328_light, Time.s.>3.8*3600 & Time.s.<4.2*3600, c(Time.s.,Analog.In....Ch.2.AIn.2...Dem..AOut.2.))#６h PNGファイルから目視でピーク前後の時間数を入力

peakID4max_36f7_200328_light<-subset(peakID4_36f7_200328_light, Analog.In....Ch.2.AIn.2...Dem..AOut.2. == max(Analog.In....Ch.2.AIn.2...Dem..AOut.2.))
peakID4max_36f7_200328_light#最大値すなわちPeakを見つけ出す

xpeakID4max_36f7_200328_light<-peakID4max_36f7_200328_light$Time.s.
xpeakID4max_36f7_200328_light#最大値すなわちPeakの時間を指定

xpeakID4maxh_36f7_200328_light<-xpeakID4max_36f7_200328_light/3600
xpeakID4maxh_36f7_200328_light#最大値すなわちPeakの時間を指定、時間表示なので、思ったものか６h PNGファイルで確認。

ypeakID4max_36f7_200328_light<-peakID4max_36f7_200328_light$Analog.In....Ch.2.AIn.2...Dem..AOut.2.
ypeakID4max_36f7_200328_light#最大値すなわちPeakのRaw値を指定

peakIDm4_36f7_200328_light<-subset(SEanalysisdata_36f7_200328_light, Time.s.>xpeakID4max_36f7_200328_light-120 & Time.s.<xpeakID4max_36f7_200328_light+120, c(Time.s.,Analog.In....Ch.2.AIn.2...Dem..AOut.2.))#最大値すなわちPeakから前後120sのデータだけひっぱてくる。
peakIDm4_36f7_200328_light<<-sweep(peakIDm4_36f7_200328_light,2,c(xpeakID4max_36f7_200328_light,0))#最大値すなわちPeakから前後120sのデータでPeakを0sにする。
write.csv(peakIDm4_36f7_200328_light, "Kiss1-36f7_200328_light_peakID4.csv")

peakIDm4_36f7_200328_light_base<-subset(SEanalysisdata_36f7_200328_light, Time.s.>xpeakID4max_36f7_200328_light-240 & Time.s.<xpeakID4max_36f7_200328_light-120, c(Time.s.,Analog.In....Ch.2.AIn.2...Dem..AOut.2.))#最大値すなわちPeakから前240sから120sをbaselineに採用
peakIDm4_36f7_200328_light_f<-mean(peakIDm4_36f7_200328_light_base$Analog.In....Ch.2.AIn.2...Dem..AOut.2.)#Fbase平均の計算
peakIDm4_36f7_200328_light_dff<-(peakIDm4_36f7_200328_light$Analog.In....Ch.2.AIn.2...Dem..AOut.2.-peakIDm4_36f7_200328_light_f)/peakIDm4_36f7_200328_light_f#dF/Fの計算
names(peakIDm4_36f7_200328_light_dff)

peakIDm4_36f7_200328_light_dff <-data.frame(peakIDm4_36f7_200328_light$Time.s.,peakIDm4_36f7_200328_light_dff)
names(peakIDm4_36f7_200328_light_dff)

write.csv(peakIDm4_36f7_200328_light_dff, "Kiss1-36f7_200328_light_peakID4_dff.csv")

ypeakIDm4_36f7_200328_light_sd<-sd(peakIDm4_36f7_200328_light_base$Analog.In....Ch.2.AIn.2...Dem..AOut.2.)
ypeakIDm4_36f7_200328_light_Zscore<-(peakIDm4_36f7_200328_light$Analog.In....Ch.2.AIn.2...Dem..AOut.2.-peakIDm4_36f7_200328_light_f)/ypeakIDm4_36f7_200328_light_sd

peakIDm4_36f7_200328_light_Zscore <-data.frame(peakIDm4_36f7_200328_light$Time.s.,ypeakIDm4_36f7_200328_light_Zscore)
names(peakIDm4_36f7_200328_light_Zscore)

write.csv(peakIDm4_36f7_200328_light_Zscore, "Kiss1-36f7_200328_light_peakID4_Zscore.csv")

peakIDm4max_36f7_200328_light_dff<-(ypeakID4max_36f7_200328_light-peakIDm4_36f7_200328_light_f)/peakIDm4_36f7_200328_light_f#peakのdF/Fの計算
peakIDm4max_36f7_200328_light_dff


xID4_36f7_200328_light<-peakIDm4_36f7_200328_light_dff$peakIDm4_36f7_200328_light.Time.s.
yID4_36f7_200328_light<-peakIDm4_36f7_200328_light_dff$peakIDm4_36f7_200328_light_dff/peakIDm4max_36f7_200328_light_dff#max値で割ることによってNormalizeする→peakが1になる

png("Kiss1-36f7_200328_light_peakID4.png", width = 400, height = 300, bg="transparent")
#X軸、Y軸を表示します。
xmin=-120#X軸の最小値
xmax=+120#X軸の最大値
xint=30#X軸の間隔
ymin=-0.2#Y軸の最小値
ymax=1.2#Y軸の最大値
yint=0.2#Y軸の間隔
plot(xID4_36f7_200328_light,yID4_36f7_200328_light,type="l", pch=16, cex=1, lwd=1,las=1, bg="transparent", xlim=c(xmin, xmax), ylim=c(ymin, ymax),axes=FALSE,an=FALSE)
axis(2,at=seq(ymin, ymax,yint), tcl=0.3, mgp=c(1,0.5,0.5),lwd=2,las=1)
axis(1,at=seq(xmin, xmax, xint), labels=c("-120","-90","-60","-30","0","30","60","90","120"), tcl=0.3, mgp=c(0,0.3,0),lwd=2,las=1)

mtext("Normalized ∆F/F (%)", side=2, line=2.5, cex=1)
mtext("Time (sec)", side=1, line=1.5, cex=1)
dev.off()

#left, right edge, fwhm of pulse 
y_halfmax_peakID4_36f7_200328_light<-peakIDm4max_36f7_200328_light_dff/2
halfmax_peakID4_36f7_200328_light<- subset(peakIDm4_36f7_200328_light_dff,peakIDm4_36f7_200328_light_dff>y_halfmax_peakID4_36f7_200328_light, c(peakIDm4_36f7_200328_light.Time.s.,peakIDm4_36f7_200328_light_dff))

leftedge_halfmax_peakID4_36f7_200328_light<-subset(halfmax_peakID4_36f7_200328_light, peakIDm4_36f7_200328_light.Time.s.<0, c(peakIDm4_36f7_200328_light.Time.s.,peakIDm4_36f7_200328_light_dff))
leftedge_halfmax_peakID4_36f7_200328_light<-subset(leftedge_halfmax_peakID4_36f7_200328_light, peakIDm4_36f7_200328_light_dff == min(peakIDm4_36f7_200328_light_dff))
leftedge_halfmax_peakID4_36f7_200328_light
x_leftedge_halfmax_peakID4_36f7_200328_light<-leftedge_halfmax_peakID4_36f7_200328_light$peakIDm4_36f7_200328_light.Time.s.
x_leftedge_halfmax_peakID4_36f7_200328_light

rightedge_halfmax_peakID4_36f7_200328_light<-subset(halfmax_peakID4_36f7_200328_light, peakIDm4_36f7_200328_light.Time.s.>0, c(peakIDm4_36f7_200328_light.Time.s.,peakIDm4_36f7_200328_light_dff))
rightedge_halfmax_peakID4_36f7_200328_light<-subset(rightedge_halfmax_peakID4_36f7_200328_light, peakIDm4_36f7_200328_light_dff == min(peakIDm4_36f7_200328_light_dff))
rightedge_halfmax_peakID4_36f7_200328_light
x_rightedge_halfmax_peakID4_36f7_200328_light<-rightedge_halfmax_peakID4_36f7_200328_light$peakIDm4_36f7_200328_light.Time.s.
x_rightedge_halfmax_peakID4_36f7_200328_light

fwhm_peakID4_36f7_200328_light<-x_rightedge_halfmax_peakID4_36f7_200328_light-x_leftedge_halfmax_peakID4_36f7_200328_light
fwhm_peakID4_36f7_200328_light

y_thirdmax_peakID4_36f7_200328_light<-peakIDm4max_36f7_200328_light_dff/3
thirdmax_peakID4_36f7_200328_light<- subset(peakIDm4_36f7_200328_light_dff,peakIDm4_36f7_200328_light_dff>y_thirdmax_peakID4_36f7_200328_light, c(peakIDm4_36f7_200328_light.Time.s.,peakIDm4_36f7_200328_light_dff))

leftedge_thirdmax_peakID4_36f7_200328_light<-subset(thirdmax_peakID4_36f7_200328_light, peakIDm4_36f7_200328_light.Time.s.<0, c(peakIDm4_36f7_200328_light.Time.s.,peakIDm4_36f7_200328_light_dff))
leftedge_thirdmax_peakID4_36f7_200328_light<-subset(leftedge_thirdmax_peakID4_36f7_200328_light, peakIDm4_36f7_200328_light_dff == min(peakIDm4_36f7_200328_light_dff))
leftedge_thirdmax_peakID4_36f7_200328_light
x_leftedge_thirdmax_peakID4_36f7_200328_light<-leftedge_thirdmax_peakID4_36f7_200328_light$peakIDm4_36f7_200328_light.Time.s.
x_leftedge_thirdmax_peakID4_36f7_200328_light

rightedge_thirdmax_peakID4_36f7_200328_light<-subset(thirdmax_peakID4_36f7_200328_light, peakIDm4_36f7_200328_light.Time.s.>0, c(peakIDm4_36f7_200328_light.Time.s.,peakIDm4_36f7_200328_light_dff))
rightedge_thirdmax_peakID4_36f7_200328_light<-subset(rightedge_thirdmax_peakID4_36f7_200328_light, peakIDm4_36f7_200328_light_dff == min(peakIDm4_36f7_200328_light_dff))
rightedge_thirdmax_peakID4_36f7_200328_light
x_rightedge_thirdmax_peakID4_36f7_200328_light<-rightedge_thirdmax_peakID4_36f7_200328_light$peakIDm4_36f7_200328_light.Time.s.
x_rightedge_thirdmax_peakID4_36f7_200328_light

fw3rdm_peakID4_36f7_200328_light<-x_rightedge_thirdmax_peakID4_36f7_200328_light-x_leftedge_thirdmax_peakID4_36f7_200328_light
fw3rdm_peakID4_36f7_200328_light

y_fourthmax_peakID4_36f7_200328_light<-peakIDm4max_36f7_200328_light_dff/4
fourthmax_peakID4_36f7_200328_light<- subset(peakIDm4_36f7_200328_light_dff,peakIDm4_36f7_200328_light_dff>y_fourthmax_peakID4_36f7_200328_light, c(peakIDm4_36f7_200328_light.Time.s.,peakIDm4_36f7_200328_light_dff))

leftedge_fourthmax_peakID4_36f7_200328_light<-subset(fourthmax_peakID4_36f7_200328_light, peakIDm4_36f7_200328_light.Time.s.<0, c(peakIDm4_36f7_200328_light.Time.s.,peakIDm4_36f7_200328_light_dff))
leftedge_fourthmax_peakID4_36f7_200328_light<-subset(leftedge_fourthmax_peakID4_36f7_200328_light, peakIDm4_36f7_200328_light_dff == min(peakIDm4_36f7_200328_light_dff))
leftedge_fourthmax_peakID4_36f7_200328_light
x_leftedge_fourthmax_peakID4_36f7_200328_light<-leftedge_fourthmax_peakID4_36f7_200328_light$peakIDm4_36f7_200328_light.Time.s.
x_leftedge_fourthmax_peakID4_36f7_200328_light

rightedge_fourthmax_peakID4_36f7_200328_light<-subset(fourthmax_peakID4_36f7_200328_light, peakIDm4_36f7_200328_light.Time.s.>0, c(peakIDm4_36f7_200328_light.Time.s.,peakIDm4_36f7_200328_light_dff))
rightedge_fourthmax_peakID4_36f7_200328_light<-subset(rightedge_fourthmax_peakID4_36f7_200328_light, peakIDm4_36f7_200328_light_dff == min(peakIDm4_36f7_200328_light_dff))
rightedge_fourthmax_peakID4_36f7_200328_light
x_rightedge_fourthmax_peakID4_36f7_200328_light<-rightedge_fourthmax_peakID4_36f7_200328_light$peakIDm4_36f7_200328_light.Time.s.
x_rightedge_fourthmax_peakID4_36f7_200328_light

fw4thm_peakID4_36f7_200328_light<-x_rightedge_fourthmax_peakID4_36f7_200328_light-x_leftedge_fourthmax_peakID4_36f7_200328_light
fw4thm_peakID4_36f7_200328_light



#base analysis
#固定Pre:-110,-80,-50から-20秒、Post:30秒から60秒、90秒
left_base_peakIDm4_36f7_200328_light_30<-subset(peakIDm4_36f7_200328_light_dff, peakIDm4_36f7_200328_light.Time.s.>-50 & peakIDm4_36f7_200328_light.Time.s.< -20, c(peakIDm4_36f7_200328_light.Time.s.,peakIDm4_36f7_200328_light_dff))
ave_left_base_peakIDm4_36f7_200328_light_30<-mean(left_base_peakIDm4_36f7_200328_light_30$peakIDm4_36f7_200328_light_dff)
ave_left_base_peakIDm4_36f7_200328_light_30
SD_left_base_peakIDm4_36f7_200328_light_30<-sd(left_base_peakIDm4_36f7_200328_light_30$peakIDm4_36f7_200328_light_dff)
SD_left_base_peakIDm4_36f7_200328_light_30
CV_left_base_peakIDm4_36f7_200328_light_30<-SD_left_base_peakIDm4_36f7_200328_light_30/ave_left_base_peakIDm4_36f7_200328_light_30
CV_left_base_peakIDm4_36f7_200328_light_30

left_base_peakIDm4_36f7_200328_light_60<-subset(peakIDm4_36f7_200328_light_dff, peakIDm4_36f7_200328_light.Time.s.>-80 & peakIDm4_36f7_200328_light.Time.s.< -50, c(peakIDm4_36f7_200328_light.Time.s.,peakIDm4_36f7_200328_light_dff))
ave_left_base_peakIDm4_36f7_200328_light_60<-mean(left_base_peakIDm4_36f7_200328_light_60$peakIDm4_36f7_200328_light_dff)
ave_left_base_peakIDm4_36f7_200328_light_60
SD_left_base_peakIDm4_36f7_200328_light_60<-sd(left_base_peakIDm4_36f7_200328_light_60$peakIDm4_36f7_200328_light_dff)
SD_left_base_peakIDm4_36f7_200328_light_60
CV_left_base_peakIDm4_36f7_200328_light_60<-SD_left_base_peakIDm4_36f7_200328_light_60/ave_left_base_peakIDm4_36f7_200328_light_60
CV_left_base_peakIDm4_36f7_200328_light_60

left_base_peakIDm4_36f7_200328_light_90<-subset(peakIDm4_36f7_200328_light_dff, peakIDm4_36f7_200328_light.Time.s.>-110 & peakIDm4_36f7_200328_light.Time.s.< -80, c(peakIDm4_36f7_200328_light.Time.s.,peakIDm4_36f7_200328_light_dff))
ave_left_base_peakIDm4_36f7_200328_light_90<-mean(left_base_peakIDm4_36f7_200328_light_90$peakIDm4_36f7_200328_light_dff)
ave_left_base_peakIDm4_36f7_200328_light_90
SD_left_base_peakIDm4_36f7_200328_light_90<-sd(left_base_peakIDm4_36f7_200328_light_90$peakIDm4_36f7_200328_light_dff)
SD_left_base_peakIDm4_36f7_200328_light_90
CV_left_base_peakIDm4_36f7_200328_light_90<-SD_left_base_peakIDm4_36f7_200328_light_90/ave_left_base_peakIDm4_36f7_200328_light_90
CV_left_base_peakIDm4_36f7_200328_light_90

right_base_peakIDm4_36f7_200328_light_30<-subset(peakIDm4_36f7_200328_light_dff, peakIDm4_36f7_200328_light.Time.s.>-60 & peakIDm4_36f7_200328_light.Time.s.< -30, c(peakIDm4_36f7_200328_light.Time.s.,peakIDm4_36f7_200328_light_dff))
ave_right_base_peakIDm4_36f7_200328_light_30<-mean(right_base_peakIDm4_36f7_200328_light_30$peakIDm4_36f7_200328_light_dff)
ave_right_base_peakIDm4_36f7_200328_light_30
SD_right_base_peakIDm4_36f7_200328_light_30<-sd(right_base_peakIDm4_36f7_200328_light_30$peakIDm4_36f7_200328_light_dff)
SD_right_base_peakIDm4_36f7_200328_light_30
CV_right_base_peakIDm4_36f7_200328_light_30<-SD_right_base_peakIDm4_36f7_200328_light_30/ave_right_base_peakIDm4_36f7_200328_light_30
CV_right_base_peakIDm4_36f7_200328_light_30

right_base_peakIDm4_36f7_200328_light_60<-subset(peakIDm4_36f7_200328_light_dff, peakIDm4_36f7_200328_light.Time.s.>-90 & peakIDm4_36f7_200328_light.Time.s.< -60, c(peakIDm4_36f7_200328_light.Time.s.,peakIDm4_36f7_200328_light_dff))
ave_right_base_peakIDm4_36f7_200328_light_60<-mean(right_base_peakIDm4_36f7_200328_light_60$peakIDm4_36f7_200328_light_dff)
ave_right_base_peakIDm4_36f7_200328_light_60
SD_right_base_peakIDm4_36f7_200328_light_60<-sd(right_base_peakIDm4_36f7_200328_light_60$peakIDm4_36f7_200328_light_dff)
SD_right_base_peakIDm4_36f7_200328_light_60
CV_right_base_peakIDm4_36f7_200328_light_60<-SD_right_base_peakIDm4_36f7_200328_light_60/ave_right_base_peakIDm4_36f7_200328_light_60
CV_right_base_peakIDm4_36f7_200328_light_60

right_base_peakIDm4_36f7_200328_light_90<-subset(peakIDm4_36f7_200328_light_dff, peakIDm4_36f7_200328_light.Time.s.>-120 & peakIDm4_36f7_200328_light.Time.s.< -90, c(peakIDm4_36f7_200328_light.Time.s.,peakIDm4_36f7_200328_light_dff))
ave_right_base_peakIDm4_36f7_200328_light_90<-mean(right_base_peakIDm4_36f7_200328_light_90$peakIDm4_36f7_200328_light_dff)
ave_right_base_peakIDm4_36f7_200328_light_90
SD_right_base_peakIDm4_36f7_200328_light_90<-sd(right_base_peakIDm4_36f7_200328_light_90$peakIDm4_36f7_200328_light_dff)
SD_right_base_peakIDm4_36f7_200328_light_90
CV_right_base_peakIDm4_36f7_200328_light_90<-SD_right_base_peakIDm4_36f7_200328_light_90/ave_right_base_peakIDm4_36f7_200328_light_90
CV_right_base_peakIDm4_36f7_200328_light_90







peakID5_36f7_200328_light<-subset(SEanalysisdata_36f7_200328_light, Time.s.>4.67*3600 & Time.s.<5*3600, c(Time.s.,Analog.In....Ch.2.AIn.2...Dem..AOut.2.))#６h PNGファイルから目視でピーク前後の時間数を入力

peakID5max_36f7_200328_light<-subset(peakID5_36f7_200328_light, Analog.In....Ch.2.AIn.2...Dem..AOut.2. == max(Analog.In....Ch.2.AIn.2...Dem..AOut.2.))
peakID5max_36f7_200328_light#最大値すなわちPeakを見つけ出す

xpeakID5max_36f7_200328_light<-peakID5max_36f7_200328_light$Time.s.
xpeakID5max_36f7_200328_light#最大値すなわちPeakの時間を指定

xpeakID5maxh_36f7_200328_light<-xpeakID5max_36f7_200328_light/3600
xpeakID5maxh_36f7_200328_light#最大値すなわちPeakの時間を指定、時間表示なので、思ったものか６h PNGファイルで確認。

ypeakID5max_36f7_200328_light<-peakID5max_36f7_200328_light$Analog.In....Ch.2.AIn.2...Dem..AOut.2.
ypeakID5max_36f7_200328_light#最大値すなわちPeakのRaw値を指定

peakIDm5_36f7_200328_light<-subset(SEanalysisdata_36f7_200328_light, Time.s.>xpeakID5max_36f7_200328_light-120 & Time.s.<xpeakID5max_36f7_200328_light+120, c(Time.s.,Analog.In....Ch.2.AIn.2...Dem..AOut.2.))#最大値すなわちPeakから前後120sのデータだけひっぱてくる。
peakIDm5_36f7_200328_light<<-sweep(peakIDm5_36f7_200328_light,2,c(xpeakID5max_36f7_200328_light,0))#最大値すなわちPeakから前後120sのデータでPeakを0sにする。
write.csv(peakIDm5_36f7_200328_light, "Kiss1-36f7_200328_light_peakID5.csv")

peakIDm5_36f7_200328_light_base<-subset(SEanalysisdata_36f7_200328_light, Time.s.>xpeakID5max_36f7_200328_light-240 & Time.s.<xpeakID5max_36f7_200328_light-120, c(Time.s.,Analog.In....Ch.2.AIn.2...Dem..AOut.2.))#最大値すなわちPeakから前240sから120sをbaselineに採用
peakIDm5_36f7_200328_light_f<-mean(peakIDm5_36f7_200328_light_base$Analog.In....Ch.2.AIn.2...Dem..AOut.2.)#Fbase平均の計算
peakIDm5_36f7_200328_light_dff<-(peakIDm5_36f7_200328_light$Analog.In....Ch.2.AIn.2...Dem..AOut.2.-peakIDm5_36f7_200328_light_f)/peakIDm5_36f7_200328_light_f#dF/Fの計算
names(peakIDm5_36f7_200328_light_dff)

peakIDm5_36f7_200328_light_dff <-data.frame(peakIDm5_36f7_200328_light$Time.s.,peakIDm5_36f7_200328_light_dff)
names(peakIDm5_36f7_200328_light_dff)

write.csv(peakIDm5_36f7_200328_light_dff, "Kiss1-36f7_200328_light_peakID5_dff.csv")

ypeakIDm5_36f7_200328_light_sd<-sd(peakIDm5_36f7_200328_light_base$Analog.In....Ch.2.AIn.2...Dem..AOut.2.)
ypeakIDm5_36f7_200328_light_Zscore<-(peakIDm5_36f7_200328_light$Analog.In....Ch.2.AIn.2...Dem..AOut.2.-peakIDm5_36f7_200328_light_f)/ypeakIDm5_36f7_200328_light_sd

peakIDm5_36f7_200328_light_Zscore <-data.frame(peakIDm5_36f7_200328_light$Time.s.,ypeakIDm5_36f7_200328_light_Zscore)
names(peakIDm5_36f7_200328_light_Zscore)

write.csv(peakIDm5_36f7_200328_light_Zscore, "Kiss1-36f7_200328_light_peakID5_Zscore.csv")

peakIDm5max_36f7_200328_light_dff<-(ypeakID5max_36f7_200328_light-peakIDm5_36f7_200328_light_f)/peakIDm5_36f7_200328_light_f#peakのdF/Fの計算
peakIDm5max_36f7_200328_light_dff


xID5_36f7_200328_light<-peakIDm5_36f7_200328_light_dff$peakIDm5_36f7_200328_light.Time.s.
yID5_36f7_200328_light<-peakIDm5_36f7_200328_light_dff$peakIDm5_36f7_200328_light_dff/peakIDm5max_36f7_200328_light_dff#max値で割ることによってNormalizeする→peakが1になる

png("Kiss1-36f7_200328_light_peakID5.png", width = 400, height = 300, bg="transparent")
#X軸、Y軸を表示します。
xmin=-120#X軸の最小値
xmax=+120#X軸の最大値
xint=30#X軸の間隔
ymin=-0.2#Y軸の最小値
ymax=1.2#Y軸の最大値
yint=0.2#Y軸の間隔
plot(xID5_36f7_200328_light,yID5_36f7_200328_light,type="l", pch=16, cex=1, lwd=1,las=1, bg="transparent", xlim=c(xmin, xmax), ylim=c(ymin, ymax),axes=FALSE,an=FALSE)
axis(2,at=seq(ymin, ymax,yint), tcl=0.3, mgp=c(1,0.5,0.5),lwd=2,las=1)
axis(1,at=seq(xmin, xmax, xint), labels=c("-120","-90","-60","-30","0","30","60","90","120"), tcl=0.3, mgp=c(0,0.3,0),lwd=2,las=1)

mtext("Normalized ∆F/F (%)", side=2, line=2.5, cex=1)
mtext("Time (sec)", side=1, line=1.5, cex=1)
dev.off()

#left, right edge, fwhm of pulse 
y_halfmax_peakID5_36f7_200328_light<-peakIDm5max_36f7_200328_light_dff/2
halfmax_peakID5_36f7_200328_light<- subset(peakIDm5_36f7_200328_light_dff,peakIDm5_36f7_200328_light_dff>y_halfmax_peakID5_36f7_200328_light, c(peakIDm5_36f7_200328_light.Time.s.,peakIDm5_36f7_200328_light_dff))

leftedge_halfmax_peakID5_36f7_200328_light<-subset(halfmax_peakID5_36f7_200328_light, peakIDm5_36f7_200328_light.Time.s.<0, c(peakIDm5_36f7_200328_light.Time.s.,peakIDm5_36f7_200328_light_dff))
leftedge_halfmax_peakID5_36f7_200328_light<-subset(leftedge_halfmax_peakID5_36f7_200328_light, peakIDm5_36f7_200328_light_dff == min(peakIDm5_36f7_200328_light_dff))
leftedge_halfmax_peakID5_36f7_200328_light
x_leftedge_halfmax_peakID5_36f7_200328_light<-leftedge_halfmax_peakID5_36f7_200328_light$peakIDm5_36f7_200328_light.Time.s.
x_leftedge_halfmax_peakID5_36f7_200328_light

rightedge_halfmax_peakID5_36f7_200328_light<-subset(halfmax_peakID5_36f7_200328_light, peakIDm5_36f7_200328_light.Time.s.>0, c(peakIDm5_36f7_200328_light.Time.s.,peakIDm5_36f7_200328_light_dff))
rightedge_halfmax_peakID5_36f7_200328_light<-subset(rightedge_halfmax_peakID5_36f7_200328_light, peakIDm5_36f7_200328_light_dff == min(peakIDm5_36f7_200328_light_dff))
rightedge_halfmax_peakID5_36f7_200328_light
x_rightedge_halfmax_peakID5_36f7_200328_light<-rightedge_halfmax_peakID5_36f7_200328_light$peakIDm5_36f7_200328_light.Time.s.
x_rightedge_halfmax_peakID5_36f7_200328_light

fwhm_peakID5_36f7_200328_light<-x_rightedge_halfmax_peakID5_36f7_200328_light-x_leftedge_halfmax_peakID5_36f7_200328_light
fwhm_peakID5_36f7_200328_light

y_thirdmax_peakID5_36f7_200328_light<-peakIDm5max_36f7_200328_light_dff/3
thirdmax_peakID5_36f7_200328_light<- subset(peakIDm5_36f7_200328_light_dff,peakIDm5_36f7_200328_light_dff>y_thirdmax_peakID5_36f7_200328_light, c(peakIDm5_36f7_200328_light.Time.s.,peakIDm5_36f7_200328_light_dff))

leftedge_thirdmax_peakID5_36f7_200328_light<-subset(thirdmax_peakID5_36f7_200328_light, peakIDm5_36f7_200328_light.Time.s.<0, c(peakIDm5_36f7_200328_light.Time.s.,peakIDm5_36f7_200328_light_dff))
leftedge_thirdmax_peakID5_36f7_200328_light<-subset(leftedge_thirdmax_peakID5_36f7_200328_light, peakIDm5_36f7_200328_light_dff == min(peakIDm5_36f7_200328_light_dff))
leftedge_thirdmax_peakID5_36f7_200328_light
x_leftedge_thirdmax_peakID5_36f7_200328_light<-leftedge_thirdmax_peakID5_36f7_200328_light$peakIDm5_36f7_200328_light.Time.s.
x_leftedge_thirdmax_peakID5_36f7_200328_light

rightedge_thirdmax_peakID5_36f7_200328_light<-subset(thirdmax_peakID5_36f7_200328_light, peakIDm5_36f7_200328_light.Time.s.>0, c(peakIDm5_36f7_200328_light.Time.s.,peakIDm5_36f7_200328_light_dff))
rightedge_thirdmax_peakID5_36f7_200328_light<-subset(rightedge_thirdmax_peakID5_36f7_200328_light, peakIDm5_36f7_200328_light_dff == min(peakIDm5_36f7_200328_light_dff))
rightedge_thirdmax_peakID5_36f7_200328_light
x_rightedge_thirdmax_peakID5_36f7_200328_light<-rightedge_thirdmax_peakID5_36f7_200328_light$peakIDm5_36f7_200328_light.Time.s.
x_rightedge_thirdmax_peakID5_36f7_200328_light

fw3rdm_peakID5_36f7_200328_light<-x_rightedge_thirdmax_peakID5_36f7_200328_light-x_leftedge_thirdmax_peakID5_36f7_200328_light
fw3rdm_peakID5_36f7_200328_light

y_fourthmax_peakID5_36f7_200328_light<-peakIDm5max_36f7_200328_light_dff/4
fourthmax_peakID5_36f7_200328_light<- subset(peakIDm5_36f7_200328_light_dff,peakIDm5_36f7_200328_light_dff>y_fourthmax_peakID5_36f7_200328_light, c(peakIDm5_36f7_200328_light.Time.s.,peakIDm5_36f7_200328_light_dff))

leftedge_fourthmax_peakID5_36f7_200328_light<-subset(fourthmax_peakID5_36f7_200328_light, peakIDm5_36f7_200328_light.Time.s.<0, c(peakIDm5_36f7_200328_light.Time.s.,peakIDm5_36f7_200328_light_dff))
leftedge_fourthmax_peakID5_36f7_200328_light<-subset(leftedge_fourthmax_peakID5_36f7_200328_light, peakIDm5_36f7_200328_light_dff == min(peakIDm5_36f7_200328_light_dff))
leftedge_fourthmax_peakID5_36f7_200328_light
x_leftedge_fourthmax_peakID5_36f7_200328_light<-leftedge_fourthmax_peakID5_36f7_200328_light$peakIDm5_36f7_200328_light.Time.s.
x_leftedge_fourthmax_peakID5_36f7_200328_light

rightedge_fourthmax_peakID5_36f7_200328_light<-subset(fourthmax_peakID5_36f7_200328_light, peakIDm5_36f7_200328_light.Time.s.>0, c(peakIDm5_36f7_200328_light.Time.s.,peakIDm5_36f7_200328_light_dff))
rightedge_fourthmax_peakID5_36f7_200328_light<-subset(rightedge_fourthmax_peakID5_36f7_200328_light, peakIDm5_36f7_200328_light_dff == min(peakIDm5_36f7_200328_light_dff))
rightedge_fourthmax_peakID5_36f7_200328_light
x_rightedge_fourthmax_peakID5_36f7_200328_light<-rightedge_fourthmax_peakID5_36f7_200328_light$peakIDm5_36f7_200328_light.Time.s.
x_rightedge_fourthmax_peakID5_36f7_200328_light

fw4thm_peakID5_36f7_200328_light<-x_rightedge_fourthmax_peakID5_36f7_200328_light-x_leftedge_fourthmax_peakID5_36f7_200328_light
fw4thm_peakID5_36f7_200328_light



#base analysis
#固定Pre:-110,-80,-50から-20秒、Post:30秒から60秒、90秒
left_base_peakIDm5_36f7_200328_light_30<-subset(peakIDm5_36f7_200328_light_dff, peakIDm5_36f7_200328_light.Time.s.>-50 & peakIDm5_36f7_200328_light.Time.s.< -20, c(peakIDm5_36f7_200328_light.Time.s.,peakIDm5_36f7_200328_light_dff))
ave_left_base_peakIDm5_36f7_200328_light_30<-mean(left_base_peakIDm5_36f7_200328_light_30$peakIDm5_36f7_200328_light_dff)
ave_left_base_peakIDm5_36f7_200328_light_30
SD_left_base_peakIDm5_36f7_200328_light_30<-sd(left_base_peakIDm5_36f7_200328_light_30$peakIDm5_36f7_200328_light_dff)
SD_left_base_peakIDm5_36f7_200328_light_30
CV_left_base_peakIDm5_36f7_200328_light_30<-SD_left_base_peakIDm5_36f7_200328_light_30/ave_left_base_peakIDm5_36f7_200328_light_30
CV_left_base_peakIDm5_36f7_200328_light_30

left_base_peakIDm5_36f7_200328_light_60<-subset(peakIDm5_36f7_200328_light_dff, peakIDm5_36f7_200328_light.Time.s.>-80 & peakIDm5_36f7_200328_light.Time.s.< -50, c(peakIDm5_36f7_200328_light.Time.s.,peakIDm5_36f7_200328_light_dff))
ave_left_base_peakIDm5_36f7_200328_light_60<-mean(left_base_peakIDm5_36f7_200328_light_60$peakIDm5_36f7_200328_light_dff)
ave_left_base_peakIDm5_36f7_200328_light_60
SD_left_base_peakIDm5_36f7_200328_light_60<-sd(left_base_peakIDm5_36f7_200328_light_60$peakIDm5_36f7_200328_light_dff)
SD_left_base_peakIDm5_36f7_200328_light_60
CV_left_base_peakIDm5_36f7_200328_light_60<-SD_left_base_peakIDm5_36f7_200328_light_60/ave_left_base_peakIDm5_36f7_200328_light_60
CV_left_base_peakIDm5_36f7_200328_light_60

left_base_peakIDm5_36f7_200328_light_90<-subset(peakIDm5_36f7_200328_light_dff, peakIDm5_36f7_200328_light.Time.s.>-110 & peakIDm5_36f7_200328_light.Time.s.< -80, c(peakIDm5_36f7_200328_light.Time.s.,peakIDm5_36f7_200328_light_dff))
ave_left_base_peakIDm5_36f7_200328_light_90<-mean(left_base_peakIDm5_36f7_200328_light_90$peakIDm5_36f7_200328_light_dff)
ave_left_base_peakIDm5_36f7_200328_light_90
SD_left_base_peakIDm5_36f7_200328_light_90<-sd(left_base_peakIDm5_36f7_200328_light_90$peakIDm5_36f7_200328_light_dff)
SD_left_base_peakIDm5_36f7_200328_light_90
CV_left_base_peakIDm5_36f7_200328_light_90<-SD_left_base_peakIDm5_36f7_200328_light_90/ave_left_base_peakIDm5_36f7_200328_light_90
CV_left_base_peakIDm5_36f7_200328_light_90

right_base_peakIDm5_36f7_200328_light_30<-subset(peakIDm5_36f7_200328_light_dff, peakIDm5_36f7_200328_light.Time.s.>-60 & peakIDm5_36f7_200328_light.Time.s.< -30, c(peakIDm5_36f7_200328_light.Time.s.,peakIDm5_36f7_200328_light_dff))
ave_right_base_peakIDm5_36f7_200328_light_30<-mean(right_base_peakIDm5_36f7_200328_light_30$peakIDm5_36f7_200328_light_dff)
ave_right_base_peakIDm5_36f7_200328_light_30
SD_right_base_peakIDm5_36f7_200328_light_30<-sd(right_base_peakIDm5_36f7_200328_light_30$peakIDm5_36f7_200328_light_dff)
SD_right_base_peakIDm5_36f7_200328_light_30
CV_right_base_peakIDm5_36f7_200328_light_30<-SD_right_base_peakIDm5_36f7_200328_light_30/ave_right_base_peakIDm5_36f7_200328_light_30
CV_right_base_peakIDm5_36f7_200328_light_30

right_base_peakIDm5_36f7_200328_light_60<-subset(peakIDm5_36f7_200328_light_dff, peakIDm5_36f7_200328_light.Time.s.>-90 & peakIDm5_36f7_200328_light.Time.s.< -60, c(peakIDm5_36f7_200328_light.Time.s.,peakIDm5_36f7_200328_light_dff))
ave_right_base_peakIDm5_36f7_200328_light_60<-mean(right_base_peakIDm5_36f7_200328_light_60$peakIDm5_36f7_200328_light_dff)
ave_right_base_peakIDm5_36f7_200328_light_60
SD_right_base_peakIDm5_36f7_200328_light_60<-sd(right_base_peakIDm5_36f7_200328_light_60$peakIDm5_36f7_200328_light_dff)
SD_right_base_peakIDm5_36f7_200328_light_60
CV_right_base_peakIDm5_36f7_200328_light_60<-SD_right_base_peakIDm5_36f7_200328_light_60/ave_right_base_peakIDm5_36f7_200328_light_60
CV_right_base_peakIDm5_36f7_200328_light_60

right_base_peakIDm5_36f7_200328_light_90<-subset(peakIDm5_36f7_200328_light_dff, peakIDm5_36f7_200328_light.Time.s.>-120 & peakIDm5_36f7_200328_light.Time.s.< -90, c(peakIDm5_36f7_200328_light.Time.s.,peakIDm5_36f7_200328_light_dff))
ave_right_base_peakIDm5_36f7_200328_light_90<-mean(right_base_peakIDm5_36f7_200328_light_90$peakIDm5_36f7_200328_light_dff)
ave_right_base_peakIDm5_36f7_200328_light_90
SD_right_base_peakIDm5_36f7_200328_light_90<-sd(right_base_peakIDm5_36f7_200328_light_90$peakIDm5_36f7_200328_light_dff)
SD_right_base_peakIDm5_36f7_200328_light_90
CV_right_base_peakIDm5_36f7_200328_light_90<-SD_right_base_peakIDm5_36f7_200328_light_90/ave_right_base_peakIDm5_36f7_200328_light_90
CV_right_base_peakIDm5_36f7_200328_light_90







peakID6_36f7_200328_light<-subset(SEanalysisdata_36f7_200328_light, Time.s.>5*3600 & Time.s.<5.5*3600, c(Time.s.,Analog.In....Ch.2.AIn.2...Dem..AOut.2.))#６h PNGファイルから目視でピーク前後の時間数を入力

peakID6max_36f7_200328_light<-subset(peakID6_36f7_200328_light, Analog.In....Ch.2.AIn.2...Dem..AOut.2. == max(Analog.In....Ch.2.AIn.2...Dem..AOut.2.))
peakID6max_36f7_200328_light#最大値すなわちPeakを見つけ出す

xpeakID6max_36f7_200328_light<-peakID6max_36f7_200328_light$Time.s.
xpeakID6max_36f7_200328_light#最大値すなわちPeakの時間を指定

xpeakID6maxh_36f7_200328_light<-xpeakID6max_36f7_200328_light/3600
xpeakID6maxh_36f7_200328_light#最大値すなわちPeakの時間を指定、時間表示なので、思ったものか６h PNGファイルで確認。

ypeakID6max_36f7_200328_light<-peakID6max_36f7_200328_light$Analog.In....Ch.2.AIn.2...Dem..AOut.2.
ypeakID6max_36f7_200328_light#最大値すなわちPeakのRaw値を指定

peakIDm6_36f7_200328_light<-subset(SEanalysisdata_36f7_200328_light, Time.s.>xpeakID6max_36f7_200328_light-120 & Time.s.<xpeakID6max_36f7_200328_light+120, c(Time.s.,Analog.In....Ch.2.AIn.2...Dem..AOut.2.))#最大値すなわちPeakから前後120sのデータだけひっぱてくる。
peakIDm6_36f7_200328_light<<-sweep(peakIDm6_36f7_200328_light,2,c(xpeakID6max_36f7_200328_light,0))#最大値すなわちPeakから前後120sのデータでPeakを0sにする。
write.csv(peakIDm6_36f7_200328_light, "Kiss1-36f7_200328_light_peakID6.csv")

peakIDm6_36f7_200328_light_base<-subset(SEanalysisdata_36f7_200328_light, Time.s.>xpeakID6max_36f7_200328_light-240 & Time.s.<xpeakID6max_36f7_200328_light-120, c(Time.s.,Analog.In....Ch.2.AIn.2...Dem..AOut.2.))#最大値すなわちPeakから前240sから120sをbaselineに採用
peakIDm6_36f7_200328_light_f<-mean(peakIDm6_36f7_200328_light_base$Analog.In....Ch.2.AIn.2...Dem..AOut.2.)#Fbase平均の計算
peakIDm6_36f7_200328_light_dff<-(peakIDm6_36f7_200328_light$Analog.In....Ch.2.AIn.2...Dem..AOut.2.-peakIDm6_36f7_200328_light_f)/peakIDm6_36f7_200328_light_f#dF/Fの計算
names(peakIDm6_36f7_200328_light_dff)

peakIDm6_36f7_200328_light_dff <-data.frame(peakIDm6_36f7_200328_light$Time.s.,peakIDm6_36f7_200328_light_dff)
names(peakIDm6_36f7_200328_light_dff)

write.csv(peakIDm6_36f7_200328_light_dff, "Kiss1-36f7_200328_light_peakID6_dff.csv")

ypeakIDm6_36f7_200328_light_sd<-sd(peakIDm6_36f7_200328_light_base$Analog.In....Ch.2.AIn.2...Dem..AOut.2.)
ypeakIDm6_36f7_200328_light_Zscore<-(peakIDm6_36f7_200328_light$Analog.In....Ch.2.AIn.2...Dem..AOut.2.-peakIDm6_36f7_200328_light_f)/ypeakIDm6_36f7_200328_light_sd

peakIDm6_36f7_200328_light_Zscore <-data.frame(peakIDm6_36f7_200328_light$Time.s.,ypeakIDm6_36f7_200328_light_Zscore)
names(peakIDm6_36f7_200328_light_Zscore)

write.csv(peakIDm6_36f7_200328_light_Zscore, "Kiss1-36f7_200328_light_peakID6_Zscore.csv")

peakIDm6max_36f7_200328_light_dff<-(ypeakID6max_36f7_200328_light-peakIDm6_36f7_200328_light_f)/peakIDm6_36f7_200328_light_f#peakのdF/Fの計算
peakIDm6max_36f7_200328_light_dff


xID6_36f7_200328_light<-peakIDm6_36f7_200328_light_dff$peakIDm6_36f7_200328_light.Time.s.
yID6_36f7_200328_light<-peakIDm6_36f7_200328_light_dff$peakIDm6_36f7_200328_light_dff/peakIDm6max_36f7_200328_light_dff#max値で割ることによってNormalizeする→peakが1になる

png("Kiss1-36f7_200328_light_peakID6.png", width = 400, height = 300, bg="transparent")
#X軸、Y軸を表示します。
xmin=-120#X軸の最小値
xmax=+120#X軸の最大値
xint=30#X軸の間隔
ymin=-0.2#Y軸の最小値
ymax=1.2#Y軸の最大値
yint=0.2#Y軸の間隔
plot(xID6_36f7_200328_light,yID6_36f7_200328_light,type="l", pch=16, cex=1, lwd=1,las=1, bg="transparent", xlim=c(xmin, xmax), ylim=c(ymin, ymax),axes=FALSE,an=FALSE)
axis(2,at=seq(ymin, ymax,yint), tcl=0.3, mgp=c(1,0.5,0.5),lwd=2,las=1)
axis(1,at=seq(xmin, xmax, xint), labels=c("-120","-90","-60","-30","0","30","60","90","120"), tcl=0.3, mgp=c(0,0.3,0),lwd=2,las=1)

mtext("Normalized ∆F/F (%)", side=2, line=2.5, cex=1)
mtext("Time (sec)", side=1, line=1.5, cex=1)
dev.off()

#left, right edge, fwhm of pulse 
y_halfmax_peakID6_36f7_200328_light<-peakIDm6max_36f7_200328_light_dff/2
halfmax_peakID6_36f7_200328_light<- subset(peakIDm6_36f7_200328_light_dff,peakIDm6_36f7_200328_light_dff>y_halfmax_peakID6_36f7_200328_light, c(peakIDm6_36f7_200328_light.Time.s.,peakIDm6_36f7_200328_light_dff))

leftedge_halfmax_peakID6_36f7_200328_light<-subset(halfmax_peakID6_36f7_200328_light, peakIDm6_36f7_200328_light.Time.s.<0, c(peakIDm6_36f7_200328_light.Time.s.,peakIDm6_36f7_200328_light_dff))
leftedge_halfmax_peakID6_36f7_200328_light<-subset(leftedge_halfmax_peakID6_36f7_200328_light, peakIDm6_36f7_200328_light_dff == min(peakIDm6_36f7_200328_light_dff))
leftedge_halfmax_peakID6_36f7_200328_light
x_leftedge_halfmax_peakID6_36f7_200328_light<-leftedge_halfmax_peakID6_36f7_200328_light$peakIDm6_36f7_200328_light.Time.s.
x_leftedge_halfmax_peakID6_36f7_200328_light

rightedge_halfmax_peakID6_36f7_200328_light<-subset(halfmax_peakID6_36f7_200328_light, peakIDm6_36f7_200328_light.Time.s.>0, c(peakIDm6_36f7_200328_light.Time.s.,peakIDm6_36f7_200328_light_dff))
rightedge_halfmax_peakID6_36f7_200328_light<-subset(rightedge_halfmax_peakID6_36f7_200328_light, peakIDm6_36f7_200328_light_dff == min(peakIDm6_36f7_200328_light_dff))
rightedge_halfmax_peakID6_36f7_200328_light
x_rightedge_halfmax_peakID6_36f7_200328_light<-rightedge_halfmax_peakID6_36f7_200328_light$peakIDm6_36f7_200328_light.Time.s.
x_rightedge_halfmax_peakID6_36f7_200328_light

fwhm_peakID6_36f7_200328_light<-x_rightedge_halfmax_peakID6_36f7_200328_light-x_leftedge_halfmax_peakID6_36f7_200328_light
fwhm_peakID6_36f7_200328_light

y_thirdmax_peakID6_36f7_200328_light<-peakIDm6max_36f7_200328_light_dff/3
thirdmax_peakID6_36f7_200328_light<- subset(peakIDm6_36f7_200328_light_dff,peakIDm6_36f7_200328_light_dff>y_thirdmax_peakID6_36f7_200328_light, c(peakIDm6_36f7_200328_light.Time.s.,peakIDm6_36f7_200328_light_dff))

leftedge_thirdmax_peakID6_36f7_200328_light<-subset(thirdmax_peakID6_36f7_200328_light, peakIDm6_36f7_200328_light.Time.s.<0, c(peakIDm6_36f7_200328_light.Time.s.,peakIDm6_36f7_200328_light_dff))
leftedge_thirdmax_peakID6_36f7_200328_light<-subset(leftedge_thirdmax_peakID6_36f7_200328_light, peakIDm6_36f7_200328_light_dff == min(peakIDm6_36f7_200328_light_dff))
leftedge_thirdmax_peakID6_36f7_200328_light
x_leftedge_thirdmax_peakID6_36f7_200328_light<-leftedge_thirdmax_peakID6_36f7_200328_light$peakIDm6_36f7_200328_light.Time.s.
x_leftedge_thirdmax_peakID6_36f7_200328_light

rightedge_thirdmax_peakID6_36f7_200328_light<-subset(thirdmax_peakID6_36f7_200328_light, peakIDm6_36f7_200328_light.Time.s.>0, c(peakIDm6_36f7_200328_light.Time.s.,peakIDm6_36f7_200328_light_dff))
rightedge_thirdmax_peakID6_36f7_200328_light<-subset(rightedge_thirdmax_peakID6_36f7_200328_light, peakIDm6_36f7_200328_light_dff == min(peakIDm6_36f7_200328_light_dff))
rightedge_thirdmax_peakID6_36f7_200328_light
x_rightedge_thirdmax_peakID6_36f7_200328_light<-rightedge_thirdmax_peakID6_36f7_200328_light$peakIDm6_36f7_200328_light.Time.s.
x_rightedge_thirdmax_peakID6_36f7_200328_light

fw3rdm_peakID6_36f7_200328_light<-x_rightedge_thirdmax_peakID6_36f7_200328_light-x_leftedge_thirdmax_peakID6_36f7_200328_light
fw3rdm_peakID6_36f7_200328_light

y_fourthmax_peakID6_36f7_200328_light<-peakIDm6max_36f7_200328_light_dff/4
fourthmax_peakID6_36f7_200328_light<- subset(peakIDm6_36f7_200328_light_dff,peakIDm6_36f7_200328_light_dff>y_fourthmax_peakID6_36f7_200328_light, c(peakIDm6_36f7_200328_light.Time.s.,peakIDm6_36f7_200328_light_dff))

leftedge_fourthmax_peakID6_36f7_200328_light<-subset(fourthmax_peakID6_36f7_200328_light, peakIDm6_36f7_200328_light.Time.s.<0, c(peakIDm6_36f7_200328_light.Time.s.,peakIDm6_36f7_200328_light_dff))
leftedge_fourthmax_peakID6_36f7_200328_light<-subset(leftedge_fourthmax_peakID6_36f7_200328_light, peakIDm6_36f7_200328_light_dff == min(peakIDm6_36f7_200328_light_dff))
leftedge_fourthmax_peakID6_36f7_200328_light
x_leftedge_fourthmax_peakID6_36f7_200328_light<-leftedge_fourthmax_peakID6_36f7_200328_light$peakIDm6_36f7_200328_light.Time.s.
x_leftedge_fourthmax_peakID6_36f7_200328_light

rightedge_fourthmax_peakID6_36f7_200328_light<-subset(fourthmax_peakID6_36f7_200328_light, peakIDm6_36f7_200328_light.Time.s.>0, c(peakIDm6_36f7_200328_light.Time.s.,peakIDm6_36f7_200328_light_dff))
rightedge_fourthmax_peakID6_36f7_200328_light<-subset(rightedge_fourthmax_peakID6_36f7_200328_light, peakIDm6_36f7_200328_light_dff == min(peakIDm6_36f7_200328_light_dff))
rightedge_fourthmax_peakID6_36f7_200328_light
x_rightedge_fourthmax_peakID6_36f7_200328_light<-rightedge_fourthmax_peakID6_36f7_200328_light$peakIDm6_36f7_200328_light.Time.s.
x_rightedge_fourthmax_peakID6_36f7_200328_light

fw4thm_peakID6_36f7_200328_light<-x_rightedge_fourthmax_peakID6_36f7_200328_light-x_leftedge_fourthmax_peakID6_36f7_200328_light
fw4thm_peakID6_36f7_200328_light



#base analysis
#固定Pre:-110,-80,-50から-20秒、Post:30秒から60秒、90秒
left_base_peakIDm6_36f7_200328_light_30<-subset(peakIDm6_36f7_200328_light_dff, peakIDm6_36f7_200328_light.Time.s.>-50 & peakIDm6_36f7_200328_light.Time.s.< -20, c(peakIDm6_36f7_200328_light.Time.s.,peakIDm6_36f7_200328_light_dff))
ave_left_base_peakIDm6_36f7_200328_light_30<-mean(left_base_peakIDm6_36f7_200328_light_30$peakIDm6_36f7_200328_light_dff)
ave_left_base_peakIDm6_36f7_200328_light_30
SD_left_base_peakIDm6_36f7_200328_light_30<-sd(left_base_peakIDm6_36f7_200328_light_30$peakIDm6_36f7_200328_light_dff)
SD_left_base_peakIDm6_36f7_200328_light_30
CV_left_base_peakIDm6_36f7_200328_light_30<-SD_left_base_peakIDm6_36f7_200328_light_30/ave_left_base_peakIDm6_36f7_200328_light_30
CV_left_base_peakIDm6_36f7_200328_light_30

left_base_peakIDm6_36f7_200328_light_60<-subset(peakIDm6_36f7_200328_light_dff, peakIDm6_36f7_200328_light.Time.s.>-80 & peakIDm6_36f7_200328_light.Time.s.< -50, c(peakIDm6_36f7_200328_light.Time.s.,peakIDm6_36f7_200328_light_dff))
ave_left_base_peakIDm6_36f7_200328_light_60<-mean(left_base_peakIDm6_36f7_200328_light_60$peakIDm6_36f7_200328_light_dff)
ave_left_base_peakIDm6_36f7_200328_light_60
SD_left_base_peakIDm6_36f7_200328_light_60<-sd(left_base_peakIDm6_36f7_200328_light_60$peakIDm6_36f7_200328_light_dff)
SD_left_base_peakIDm6_36f7_200328_light_60
CV_left_base_peakIDm6_36f7_200328_light_60<-SD_left_base_peakIDm6_36f7_200328_light_60/ave_left_base_peakIDm6_36f7_200328_light_60
CV_left_base_peakIDm6_36f7_200328_light_60

left_base_peakIDm6_36f7_200328_light_90<-subset(peakIDm6_36f7_200328_light_dff, peakIDm6_36f7_200328_light.Time.s.>-110 & peakIDm6_36f7_200328_light.Time.s.< -80, c(peakIDm6_36f7_200328_light.Time.s.,peakIDm6_36f7_200328_light_dff))
ave_left_base_peakIDm6_36f7_200328_light_90<-mean(left_base_peakIDm6_36f7_200328_light_90$peakIDm6_36f7_200328_light_dff)
ave_left_base_peakIDm6_36f7_200328_light_90
SD_left_base_peakIDm6_36f7_200328_light_90<-sd(left_base_peakIDm6_36f7_200328_light_90$peakIDm6_36f7_200328_light_dff)
SD_left_base_peakIDm6_36f7_200328_light_90
CV_left_base_peakIDm6_36f7_200328_light_90<-SD_left_base_peakIDm6_36f7_200328_light_90/ave_left_base_peakIDm6_36f7_200328_light_90
CV_left_base_peakIDm6_36f7_200328_light_90

right_base_peakIDm6_36f7_200328_light_30<-subset(peakIDm6_36f7_200328_light_dff, peakIDm6_36f7_200328_light.Time.s.>-60 & peakIDm6_36f7_200328_light.Time.s.< -30, c(peakIDm6_36f7_200328_light.Time.s.,peakIDm6_36f7_200328_light_dff))
ave_right_base_peakIDm6_36f7_200328_light_30<-mean(right_base_peakIDm6_36f7_200328_light_30$peakIDm6_36f7_200328_light_dff)
ave_right_base_peakIDm6_36f7_200328_light_30
SD_right_base_peakIDm6_36f7_200328_light_30<-sd(right_base_peakIDm6_36f7_200328_light_30$peakIDm6_36f7_200328_light_dff)
SD_right_base_peakIDm6_36f7_200328_light_30
CV_right_base_peakIDm6_36f7_200328_light_30<-SD_right_base_peakIDm6_36f7_200328_light_30/ave_right_base_peakIDm6_36f7_200328_light_30
CV_right_base_peakIDm6_36f7_200328_light_30

right_base_peakIDm6_36f7_200328_light_60<-subset(peakIDm6_36f7_200328_light_dff, peakIDm6_36f7_200328_light.Time.s.>-90 & peakIDm6_36f7_200328_light.Time.s.< -60, c(peakIDm6_36f7_200328_light.Time.s.,peakIDm6_36f7_200328_light_dff))
ave_right_base_peakIDm6_36f7_200328_light_60<-mean(right_base_peakIDm6_36f7_200328_light_60$peakIDm6_36f7_200328_light_dff)
ave_right_base_peakIDm6_36f7_200328_light_60
SD_right_base_peakIDm6_36f7_200328_light_60<-sd(right_base_peakIDm6_36f7_200328_light_60$peakIDm6_36f7_200328_light_dff)
SD_right_base_peakIDm6_36f7_200328_light_60
CV_right_base_peakIDm6_36f7_200328_light_60<-SD_right_base_peakIDm6_36f7_200328_light_60/ave_right_base_peakIDm6_36f7_200328_light_60
CV_right_base_peakIDm6_36f7_200328_light_60

right_base_peakIDm6_36f7_200328_light_90<-subset(peakIDm6_36f7_200328_light_dff, peakIDm6_36f7_200328_light.Time.s.>-120 & peakIDm6_36f7_200328_light.Time.s.< -90, c(peakIDm6_36f7_200328_light.Time.s.,peakIDm6_36f7_200328_light_dff))
ave_right_base_peakIDm6_36f7_200328_light_90<-mean(right_base_peakIDm6_36f7_200328_light_90$peakIDm6_36f7_200328_light_dff)
ave_right_base_peakIDm6_36f7_200328_light_90
SD_right_base_peakIDm6_36f7_200328_light_90<-sd(right_base_peakIDm6_36f7_200328_light_90$peakIDm6_36f7_200328_light_dff)
SD_right_base_peakIDm6_36f7_200328_light_90
CV_right_base_peakIDm6_36f7_200328_light_90<-SD_right_base_peakIDm6_36f7_200328_light_90/ave_right_base_peakIDm6_36f7_200328_light_90
CV_right_base_peakIDm6_36f7_200328_light_90







peakID7_36f7_200328_light<-subset(SEanalysisdata_36f7_200328_light, Time.s.>5.5*3600 & Time.s.<6*3600, c(Time.s.,Analog.In....Ch.2.AIn.2...Dem..AOut.2.))#６h PNGファイルから目視でピーク前後の時間数を入力

peakID7max_36f7_200328_light<-subset(peakID7_36f7_200328_light, Analog.In....Ch.2.AIn.2...Dem..AOut.2. == max(Analog.In....Ch.2.AIn.2...Dem..AOut.2.))
peakID7max_36f7_200328_light#最大値すなわちPeakを見つけ出す

xpeakID7max_36f7_200328_light<-peakID7max_36f7_200328_light$Time.s.
xpeakID7max_36f7_200328_light#最大値すなわちPeakの時間を指定

xpeakID7maxh_36f7_200328_light<-xpeakID7max_36f7_200328_light/3600
xpeakID7maxh_36f7_200328_light#最大値すなわちPeakの時間を指定、時間表示なので、思ったものか６h PNGファイルで確認。

ypeakID7max_36f7_200328_light<-peakID7max_36f7_200328_light$Analog.In....Ch.2.AIn.2...Dem..AOut.2.
ypeakID7max_36f7_200328_light#最大値すなわちPeakのRaw値を指定

peakIDm7_36f7_200328_light<-subset(SEanalysisdata_36f7_200328_light, Time.s.>xpeakID7max_36f7_200328_light-120 & Time.s.<xpeakID7max_36f7_200328_light+120, c(Time.s.,Analog.In....Ch.2.AIn.2...Dem..AOut.2.))#最大値すなわちPeakから前後120sのデータだけひっぱてくる。
peakIDm7_36f7_200328_light<<-sweep(peakIDm7_36f7_200328_light,2,c(xpeakID7max_36f7_200328_light,0))#最大値すなわちPeakから前後120sのデータでPeakを0sにする。
write.csv(peakIDm7_36f7_200328_light, "Kiss1-36f7_200328_light_peakID7.csv")

peakIDm7_36f7_200328_light_base<-subset(SEanalysisdata_36f7_200328_light, Time.s.>xpeakID7max_36f7_200328_light-240 & Time.s.<xpeakID7max_36f7_200328_light-120, c(Time.s.,Analog.In....Ch.2.AIn.2...Dem..AOut.2.))#最大値すなわちPeakから前240sから120sをbaselineに採用
peakIDm7_36f7_200328_light_f<-mean(peakIDm7_36f7_200328_light_base$Analog.In....Ch.2.AIn.2...Dem..AOut.2.)#Fbase平均の計算
peakIDm7_36f7_200328_light_dff<-(peakIDm7_36f7_200328_light$Analog.In....Ch.2.AIn.2...Dem..AOut.2.-peakIDm7_36f7_200328_light_f)/peakIDm7_36f7_200328_light_f#dF/Fの計算
names(peakIDm7_36f7_200328_light_dff)

peakIDm7_36f7_200328_light_dff <-data.frame(peakIDm7_36f7_200328_light$Time.s.,peakIDm7_36f7_200328_light_dff)
names(peakIDm7_36f7_200328_light_dff)

write.csv(peakIDm7_36f7_200328_light_dff, "Kiss1-36f7_200328_light_peakID7_dff.csv")

ypeakIDm7_36f7_200328_light_sd<-sd(peakIDm7_36f7_200328_light_base$Analog.In....Ch.2.AIn.2...Dem..AOut.2.)
ypeakIDm7_36f7_200328_light_Zscore<-(peakIDm7_36f7_200328_light$Analog.In....Ch.2.AIn.2...Dem..AOut.2.-peakIDm7_36f7_200328_light_f)/ypeakIDm7_36f7_200328_light_sd

peakIDm7_36f7_200328_light_Zscore <-data.frame(peakIDm7_36f7_200328_light$Time.s.,ypeakIDm7_36f7_200328_light_Zscore)
names(peakIDm7_36f7_200328_light_Zscore)

write.csv(peakIDm7_36f7_200328_light_Zscore, "Kiss1-36f7_200328_light_peakID7_Zscore.csv")

peakIDm7max_36f7_200328_light_dff<-(ypeakID7max_36f7_200328_light-peakIDm7_36f7_200328_light_f)/peakIDm7_36f7_200328_light_f#peakのdF/Fの計算
peakIDm7max_36f7_200328_light_dff


xID7_36f7_200328_light<-peakIDm7_36f7_200328_light_dff$peakIDm7_36f7_200328_light.Time.s.
yID7_36f7_200328_light<-peakIDm7_36f7_200328_light_dff$peakIDm7_36f7_200328_light_dff/peakIDm7max_36f7_200328_light_dff#max値で割ることによってNormalizeする→peakが1になる

png("Kiss1-36f7_200328_light_peakID7.png", width = 400, height = 300, bg="transparent")
#X軸、Y軸を表示します。
xmin=-120#X軸の最小値
xmax=+120#X軸の最大値
xint=30#X軸の間隔
ymin=-0.2#Y軸の最小値
ymax=1.2#Y軸の最大値
yint=0.2#Y軸の間隔
plot(xID7_36f7_200328_light,yID7_36f7_200328_light,type="l", pch=16, cex=1, lwd=1,las=1, bg="transparent", xlim=c(xmin, xmax), ylim=c(ymin, ymax),axes=FALSE,an=FALSE)
axis(2,at=seq(ymin, ymax,yint), tcl=0.3, mgp=c(1,0.5,0.5),lwd=2,las=1)
axis(1,at=seq(xmin, xmax, xint), labels=c("-120","-90","-60","-30","0","30","60","90","120"), tcl=0.3, mgp=c(0,0.3,0),lwd=2,las=1)

mtext("Normalized ∆F/F (%)", side=2, line=2.5, cex=1)
mtext("Time (sec)", side=1, line=1.5, cex=1)
dev.off()

#left, right edge, fwhm of pulse 
y_halfmax_peakID7_36f7_200328_light<-peakIDm7max_36f7_200328_light_dff/2
halfmax_peakID7_36f7_200328_light<- subset(peakIDm7_36f7_200328_light_dff,peakIDm7_36f7_200328_light_dff>y_halfmax_peakID7_36f7_200328_light, c(peakIDm7_36f7_200328_light.Time.s.,peakIDm7_36f7_200328_light_dff))

leftedge_halfmax_peakID7_36f7_200328_light<-subset(halfmax_peakID7_36f7_200328_light, peakIDm7_36f7_200328_light.Time.s.<0, c(peakIDm7_36f7_200328_light.Time.s.,peakIDm7_36f7_200328_light_dff))
leftedge_halfmax_peakID7_36f7_200328_light<-subset(leftedge_halfmax_peakID7_36f7_200328_light, peakIDm7_36f7_200328_light_dff == min(peakIDm7_36f7_200328_light_dff))
leftedge_halfmax_peakID7_36f7_200328_light
x_leftedge_halfmax_peakID7_36f7_200328_light<-leftedge_halfmax_peakID7_36f7_200328_light$peakIDm7_36f7_200328_light.Time.s.
x_leftedge_halfmax_peakID7_36f7_200328_light

rightedge_halfmax_peakID7_36f7_200328_light<-subset(halfmax_peakID7_36f7_200328_light, peakIDm7_36f7_200328_light.Time.s.>0, c(peakIDm7_36f7_200328_light.Time.s.,peakIDm7_36f7_200328_light_dff))
rightedge_halfmax_peakID7_36f7_200328_light<-subset(rightedge_halfmax_peakID7_36f7_200328_light, peakIDm7_36f7_200328_light_dff == min(peakIDm7_36f7_200328_light_dff))
rightedge_halfmax_peakID7_36f7_200328_light
x_rightedge_halfmax_peakID7_36f7_200328_light<-rightedge_halfmax_peakID7_36f7_200328_light$peakIDm7_36f7_200328_light.Time.s.
x_rightedge_halfmax_peakID7_36f7_200328_light

fwhm_peakID7_36f7_200328_light<-x_rightedge_halfmax_peakID7_36f7_200328_light-x_leftedge_halfmax_peakID7_36f7_200328_light
fwhm_peakID7_36f7_200328_light

y_thirdmax_peakID7_36f7_200328_light<-peakIDm7max_36f7_200328_light_dff/3
thirdmax_peakID7_36f7_200328_light<- subset(peakIDm7_36f7_200328_light_dff,peakIDm7_36f7_200328_light_dff>y_thirdmax_peakID7_36f7_200328_light, c(peakIDm7_36f7_200328_light.Time.s.,peakIDm7_36f7_200328_light_dff))

leftedge_thirdmax_peakID7_36f7_200328_light<-subset(thirdmax_peakID7_36f7_200328_light, peakIDm7_36f7_200328_light.Time.s.<0, c(peakIDm7_36f7_200328_light.Time.s.,peakIDm7_36f7_200328_light_dff))
leftedge_thirdmax_peakID7_36f7_200328_light<-subset(leftedge_thirdmax_peakID7_36f7_200328_light, peakIDm7_36f7_200328_light_dff == min(peakIDm7_36f7_200328_light_dff))
leftedge_thirdmax_peakID7_36f7_200328_light
x_leftedge_thirdmax_peakID7_36f7_200328_light<-leftedge_thirdmax_peakID7_36f7_200328_light$peakIDm7_36f7_200328_light.Time.s.
x_leftedge_thirdmax_peakID7_36f7_200328_light

rightedge_thirdmax_peakID7_36f7_200328_light<-subset(thirdmax_peakID7_36f7_200328_light, peakIDm7_36f7_200328_light.Time.s.>0, c(peakIDm7_36f7_200328_light.Time.s.,peakIDm7_36f7_200328_light_dff))
rightedge_thirdmax_peakID7_36f7_200328_light<-subset(rightedge_thirdmax_peakID7_36f7_200328_light, peakIDm7_36f7_200328_light_dff == min(peakIDm7_36f7_200328_light_dff))
rightedge_thirdmax_peakID7_36f7_200328_light
x_rightedge_thirdmax_peakID7_36f7_200328_light<-rightedge_thirdmax_peakID7_36f7_200328_light$peakIDm7_36f7_200328_light.Time.s.
x_rightedge_thirdmax_peakID7_36f7_200328_light

fw3rdm_peakID7_36f7_200328_light<-x_rightedge_thirdmax_peakID7_36f7_200328_light-x_leftedge_thirdmax_peakID7_36f7_200328_light
fw3rdm_peakID7_36f7_200328_light

y_fourthmax_peakID7_36f7_200328_light<-peakIDm7max_36f7_200328_light_dff/4
fourthmax_peakID7_36f7_200328_light<- subset(peakIDm7_36f7_200328_light_dff,peakIDm7_36f7_200328_light_dff>y_fourthmax_peakID7_36f7_200328_light, c(peakIDm7_36f7_200328_light.Time.s.,peakIDm7_36f7_200328_light_dff))

leftedge_fourthmax_peakID7_36f7_200328_light<-subset(fourthmax_peakID7_36f7_200328_light, peakIDm7_36f7_200328_light.Time.s.<0, c(peakIDm7_36f7_200328_light.Time.s.,peakIDm7_36f7_200328_light_dff))
leftedge_fourthmax_peakID7_36f7_200328_light<-subset(leftedge_fourthmax_peakID7_36f7_200328_light, peakIDm7_36f7_200328_light_dff == min(peakIDm7_36f7_200328_light_dff))
leftedge_fourthmax_peakID7_36f7_200328_light
x_leftedge_fourthmax_peakID7_36f7_200328_light<-leftedge_fourthmax_peakID7_36f7_200328_light$peakIDm7_36f7_200328_light.Time.s.
x_leftedge_fourthmax_peakID7_36f7_200328_light

rightedge_fourthmax_peakID7_36f7_200328_light<-subset(fourthmax_peakID7_36f7_200328_light, peakIDm7_36f7_200328_light.Time.s.>0, c(peakIDm7_36f7_200328_light.Time.s.,peakIDm7_36f7_200328_light_dff))
rightedge_fourthmax_peakID7_36f7_200328_light<-subset(rightedge_fourthmax_peakID7_36f7_200328_light, peakIDm7_36f7_200328_light_dff == min(peakIDm7_36f7_200328_light_dff))
rightedge_fourthmax_peakID7_36f7_200328_light
x_rightedge_fourthmax_peakID7_36f7_200328_light<-rightedge_fourthmax_peakID7_36f7_200328_light$peakIDm7_36f7_200328_light.Time.s.
x_rightedge_fourthmax_peakID7_36f7_200328_light

fw4thm_peakID7_36f7_200328_light<-x_rightedge_fourthmax_peakID7_36f7_200328_light-x_leftedge_fourthmax_peakID7_36f7_200328_light
fw4thm_peakID7_36f7_200328_light



#base analysis
#固定Pre:-110,-80,-50から-20秒、Post:30秒から60秒、90秒
left_base_peakIDm7_36f7_200328_light_30<-subset(peakIDm7_36f7_200328_light_dff, peakIDm7_36f7_200328_light.Time.s.>-50 & peakIDm7_36f7_200328_light.Time.s.< -20, c(peakIDm7_36f7_200328_light.Time.s.,peakIDm7_36f7_200328_light_dff))
ave_left_base_peakIDm7_36f7_200328_light_30<-mean(left_base_peakIDm7_36f7_200328_light_30$peakIDm7_36f7_200328_light_dff)
ave_left_base_peakIDm7_36f7_200328_light_30
SD_left_base_peakIDm7_36f7_200328_light_30<-sd(left_base_peakIDm7_36f7_200328_light_30$peakIDm7_36f7_200328_light_dff)
SD_left_base_peakIDm7_36f7_200328_light_30
CV_left_base_peakIDm7_36f7_200328_light_30<-SD_left_base_peakIDm7_36f7_200328_light_30/ave_left_base_peakIDm7_36f7_200328_light_30
CV_left_base_peakIDm7_36f7_200328_light_30

left_base_peakIDm7_36f7_200328_light_60<-subset(peakIDm7_36f7_200328_light_dff, peakIDm7_36f7_200328_light.Time.s.>-80 & peakIDm7_36f7_200328_light.Time.s.< -50, c(peakIDm7_36f7_200328_light.Time.s.,peakIDm7_36f7_200328_light_dff))
ave_left_base_peakIDm7_36f7_200328_light_60<-mean(left_base_peakIDm7_36f7_200328_light_60$peakIDm7_36f7_200328_light_dff)
ave_left_base_peakIDm7_36f7_200328_light_60
SD_left_base_peakIDm7_36f7_200328_light_60<-sd(left_base_peakIDm7_36f7_200328_light_60$peakIDm7_36f7_200328_light_dff)
SD_left_base_peakIDm7_36f7_200328_light_60
CV_left_base_peakIDm7_36f7_200328_light_60<-SD_left_base_peakIDm7_36f7_200328_light_60/ave_left_base_peakIDm7_36f7_200328_light_60
CV_left_base_peakIDm7_36f7_200328_light_60

left_base_peakIDm7_36f7_200328_light_90<-subset(peakIDm7_36f7_200328_light_dff, peakIDm7_36f7_200328_light.Time.s.>-110 & peakIDm7_36f7_200328_light.Time.s.< -80, c(peakIDm7_36f7_200328_light.Time.s.,peakIDm7_36f7_200328_light_dff))
ave_left_base_peakIDm7_36f7_200328_light_90<-mean(left_base_peakIDm7_36f7_200328_light_90$peakIDm7_36f7_200328_light_dff)
ave_left_base_peakIDm7_36f7_200328_light_90
SD_left_base_peakIDm7_36f7_200328_light_90<-sd(left_base_peakIDm7_36f7_200328_light_90$peakIDm7_36f7_200328_light_dff)
SD_left_base_peakIDm7_36f7_200328_light_90
CV_left_base_peakIDm7_36f7_200328_light_90<-SD_left_base_peakIDm7_36f7_200328_light_90/ave_left_base_peakIDm7_36f7_200328_light_90
CV_left_base_peakIDm7_36f7_200328_light_90

right_base_peakIDm7_36f7_200328_light_30<-subset(peakIDm7_36f7_200328_light_dff, peakIDm7_36f7_200328_light.Time.s.>-60 & peakIDm7_36f7_200328_light.Time.s.< -30, c(peakIDm7_36f7_200328_light.Time.s.,peakIDm7_36f7_200328_light_dff))
ave_right_base_peakIDm7_36f7_200328_light_30<-mean(right_base_peakIDm7_36f7_200328_light_30$peakIDm7_36f7_200328_light_dff)
ave_right_base_peakIDm7_36f7_200328_light_30
SD_right_base_peakIDm7_36f7_200328_light_30<-sd(right_base_peakIDm7_36f7_200328_light_30$peakIDm7_36f7_200328_light_dff)
SD_right_base_peakIDm7_36f7_200328_light_30
CV_right_base_peakIDm7_36f7_200328_light_30<-SD_right_base_peakIDm7_36f7_200328_light_30/ave_right_base_peakIDm7_36f7_200328_light_30
CV_right_base_peakIDm7_36f7_200328_light_30

right_base_peakIDm7_36f7_200328_light_60<-subset(peakIDm7_36f7_200328_light_dff, peakIDm7_36f7_200328_light.Time.s.>-90 & peakIDm7_36f7_200328_light.Time.s.< -60, c(peakIDm7_36f7_200328_light.Time.s.,peakIDm7_36f7_200328_light_dff))
ave_right_base_peakIDm7_36f7_200328_light_60<-mean(right_base_peakIDm7_36f7_200328_light_60$peakIDm7_36f7_200328_light_dff)
ave_right_base_peakIDm7_36f7_200328_light_60
SD_right_base_peakIDm7_36f7_200328_light_60<-sd(right_base_peakIDm7_36f7_200328_light_60$peakIDm7_36f7_200328_light_dff)
SD_right_base_peakIDm7_36f7_200328_light_60
CV_right_base_peakIDm7_36f7_200328_light_60<-SD_right_base_peakIDm7_36f7_200328_light_60/ave_right_base_peakIDm7_36f7_200328_light_60
CV_right_base_peakIDm7_36f7_200328_light_60

right_base_peakIDm7_36f7_200328_light_90<-subset(peakIDm7_36f7_200328_light_dff, peakIDm7_36f7_200328_light.Time.s.>-120 & peakIDm7_36f7_200328_light.Time.s.< -90, c(peakIDm7_36f7_200328_light.Time.s.,peakIDm7_36f7_200328_light_dff))
ave_right_base_peakIDm7_36f7_200328_light_90<-mean(right_base_peakIDm7_36f7_200328_light_90$peakIDm7_36f7_200328_light_dff)
ave_right_base_peakIDm7_36f7_200328_light_90
SD_right_base_peakIDm7_36f7_200328_light_90<-sd(right_base_peakIDm7_36f7_200328_light_90$peakIDm7_36f7_200328_light_dff)
SD_right_base_peakIDm7_36f7_200328_light_90
CV_right_base_peakIDm7_36f7_200328_light_90<-SD_right_base_peakIDm7_36f7_200328_light_90/ave_right_base_peakIDm7_36f7_200328_light_90
CV_right_base_peakIDm7_36f7_200328_light_90






###
interval<-c("ID2-ID1","ID3-ID2","ID4-ID3","ID5-ID4","ID6-ID5","ID7-ID6")
y <-c(xpeakID2max_36f7_200328_light-xpeakID1max_36f7_200328_light,xpeakID3max_36f7_200328_light-xpeakID2max_36f7_200328_light,xpeakID4max_36f7_200328_light-xpeakID3max_36f7_200328_light,xpeakID5max_36f7_200328_light-xpeakID4max_36f7_200328_light,xpeakID6max_36f7_200328_light-xpeakID5max_36f7_200328_light,xpeakID7max_36f7_200328_light-xpeakID6max_36f7_200328_light)

min <-y/60 #分minで表記
yh <- y/3600 #時間hで表記
data<-data.frame(interval,min)
data

write.csv(data, "Kiss1-36f7_200328_light_interpusle interval.csv")

###
dF_x<-c("dark_peakID1","dark_peakID2","dark_peakID3","dark_peakID4","dark_peakID5","dark_peakID6","dark_peakID7")
dF_y<-c(peakIDm1max_36f7_200328_light_dff,peakIDm2max_36f7_200328_light_dff,peakIDm3max_36f7_200328_light_dff,peakIDm4max_36f7_200328_light_dff,peakIDm5max_36f7_200328_light_dff,peakIDm6max_36f7_200328_light_dff,peakIDm7max_36f7_200328_light_dff)
data_dF<-data.frame(dF_x,dF_y)
data_dF

write.csv(data_dF, "Kiss1-36f7_200328_light_peaks-dF.csv")










#pulseの図示 individualのものとmean+-sem
###
xIDmean_36f7_200328_light<-cbind(xID1_36f7_200328_light,xID2_36f7_200328_light,xID3_36f7_200328_light,xID4_36f7_200328_light,xID5_36f7_200328_light,xID6_36f7_200328_light)
xIDave_36f7_200328_light<-rowMeans(xIDmean_36f7_200328_light)
###
yIDmean_36f7_200328_light<-cbind(yID1_36f7_200328_light,yID2_36f7_200328_light,yID3_36f7_200328_light,yID4_36f7_200328_light,yID5_36f7_200328_light,yID6_36f7_200328_light)
yIDave_36f7_200328_light<-rowMeans(yIDmean_36f7_200328_light)
yIDsem_36f7_200328_light<-apply(yIDmean_36f7_200328_light,1,sd)/sqrt(ncol(yIDmean_36f7_200328_light))

IDmean_36f7_200328_light <-data.frame(xIDave_36f7_200328_light,yIDave_36f7_200328_light,yIDsem_36f7_200328_light)
names(IDmean_36f7_200328_light)

write.csv(IDmean_36f7_200328_light, "Kiss1-36f7_200328_light_peakIDave.csv")

IDall_36f7_200328_light <-data.frame(xIDave_36f7_200328_light,yIDmean_36f7_200328_light)
names(IDall_36f7_200328_light)

write.csv(IDall_36f7_200328_light, "Kiss1-36f7_200328_light_peakIDall.csv")

png("Kiss1-36f7_200328_light_peak_all.png", width = 400, height = 300, bg="transparent") 
#X軸、Y軸を表示します。
xmin=-120#X軸の最小値
xmax=+120#X軸の最大値
xint=30#X軸の間隔
ymin=-0.2#Y軸の最小値
ymax=1.2#Y軸の最大値
yint=0.2#Y軸の間隔
plot(xID1_36f7_200328_light,yID1_36f7_200328_light,type="l", pch=16, cex=1, lwd=1,las=1, col="gray", bg="transparent", xlim=c(xmin, xmax), ylim=c(ymin, ymax),axes=FALSE,an=FALSE)
axis(2,at=seq(ymin, ymax,yint), tcl=0.3, mgp=c(1,0.5,0.5),lwd=2,las=1)
axis(1,at=seq(xmin, xmax, xint), labels=c("-120","-90","-60","-30","0","30","60","90","120"), tcl=0.3, mgp=c(0,0.3,0),lwd=2,las=1)

mtext("Normalized ∆F/F (%)", side=2, line=2.5, cex=1)
mtext("Time (sec)", side=1, line=1.5, cex=1)

par(new=T)  #上書き指定

plot(xID2_36f7_200328_light,yID2_36f7_200328_light,type="l", pch=16, cex=1, lwd=1,las=1, col="gray", bg="transparent", xlim=c(xmin, xmax), ylim=c(ymin, ymax),axes=FALSE,an=FALSE)

par(new=T)  #上書き指定

plot(xID3_36f7_200328_light,yID3_36f7_200328_light,type="l", pch=16, cex=1, lwd=1,las=1, col="gray", bg="transparent", xlim=c(xmin, xmax), ylim=c(ymin, ymax),axes=FALSE,an=FALSE)

par(new=T)  #上書き指定

plot(xID4_36f7_200328_light,yID4_36f7_200328_light,type="l", pch=16, cex=1, lwd=1,las=1, col="gray", bg="transparent", xlim=c(xmin, xmax), ylim=c(ymin, ymax),axes=FALSE,an=FALSE)

par(new=T)  #上書き指定

plot(xID5_36f7_200328_light,yID5_36f7_200328_light,type="l", pch=16, cex=1, lwd=1,las=1, col="gray", bg="transparent", xlim=c(xmin, xmax), ylim=c(ymin, ymax),axes=FALSE,an=FALSE)

par(new=T)  #上書き指定

plot(xID6_36f7_200328_light,yID6_36f7_200328_light,type="l", pch=16, cex=1, lwd=1,las=1, col="gray", bg="transparent", xlim=c(xmin, xmax), ylim=c(ymin, ymax),axes=FALSE,an=FALSE)

par(new=T)  #上書き指定

plot(xIDave_36f7_200328_light,yIDave_36f7_200328_light,type="l", pch=16, cex=1, lwd=1,las=1, col="black", bg="transparent", xlim=c(xmin, xmax), ylim=c(ymin, ymax),axes=FALSE,an=FALSE)

dev.off()

par(mfrow=c(1,1))#Quartzデバイスに出力する際にひとつのウインドウに出力するグラフの数を指定します。現在はひとつのグラフを描きます。
par(pin=c(2.0,0.8), cex=12/12)#plotSizeを規定します。現在は3x2インチ。cex=12/12は文字サイズなどが12ポイントであることを示す。

png("Kiss1-36f7_200328_light_peak_all_sem.png", width = 400, height = 300, bg="transparent") 
#X軸、Y軸を表示します。
xmin=-120#X軸の最小値
xmax=+120#X軸の最大値
xint=30#X軸の間隔
ymin=-0.2#Y軸の最小値
ymax=1.2#Y軸の最大値
yint=0.2#Y軸の間隔
plot(xIDave_36f7_200328_light,yIDave_36f7_200328_light,type="l", pch=16, cex=1, lwd=1,las=1, col="black", bg="transparent", xlim=c(xmin, xmax), ylim=c(ymin, ymax),axes=FALSE,an=FALSE)

axis(2,at=seq(ymin, ymax,yint), tcl=0.3, mgp=c(1,0.5,0.5),lwd=2,las=1)
axis(1,at=seq(xmin, xmax, xint), labels=c("-120","-90","-60","-30","0","30","60","90","120"), tcl=0.3, mgp=c(0,0.3,0),lwd=2,las=1)

mtext("Normalized ∆F/F (%)", side=2, line=2.5, cex=1)
mtext("Time (sec)", side=1, line=1.5, cex=1)

par(new=T)  #上書き指定

polygon(c(xIDave_36f7_200328_light,rev(xIDave_36f7_200328_light)), c(yIDave_36f7_200328_light+yIDsem_36f7_200328_light,rev(yIDave_36f7_200328_light-yIDsem_36f7_200328_light)),col="gray",lty=0)

par(new=T)  #上書き指定

plot(xIDave_36f7_200328_light,yIDave_36f7_200328_light,type="l", pch=16, cex=1, lwd=1,las=1, col="black", bg="transparent", xlim=c(xmin, xmax), ylim=c(ymin, ymax),axes=FALSE,an=FALSE)

dev.off()


#Z-scoreの図示 individualのものとmean+-sem
###
yIDmean_36f7_200328_light_Zscore<-cbind(ypeakIDm1_36f7_200328_light_Zscore,ypeakIDm2_36f7_200328_light_Zscore,ypeakIDm3_36f7_200328_light_Zscore,ypeakIDm4_36f7_200328_light_Zscore,ypeakIDm5_36f7_200328_light_Zscore,ypeakIDm6_36f7_200328_light_Zscore)
yIDave_36f7_200328_light_Zscore<-rowMeans(yIDmean_36f7_200328_light_Zscore)
yIDsem_36f7_200328_light_Zscore<-apply(yIDmean_36f7_200328_light_Zscore,1,sd)/sqrt(ncol(yIDmean_36f7_200328_light_Zscore))

IDmean_36f7_200328_light_Zscore <-data.frame(xIDave_36f7_200328_light,yIDave_36f7_200328_light_Zscore,yIDsem_36f7_200328_light_Zscore)
names(IDmean_36f7_200328_light_Zscore)

write.csv(IDmean_36f7_200328_light_Zscore, "Kiss1-36f7_200328_light_peakIDave_Zscore.csv")

IDall_36f7_200328_light_Zscore <-data.frame(xIDave_36f7_200328_light,yIDmean_36f7_200328_light_Zscore)
names(IDall_36f7_200328_light_Zscore)

write.csv(IDall_36f7_200328_light_Zscore, "Kiss1-36f7_200328_light_peakIDall_Zscore.csv")

png("Kiss1-36f7_200328_light_peak_Zscore_all.png", width = 400, height = 300, bg="transparent") 
#X軸、Y軸を表示します。
xmin=-120#X軸の最小値
xmax=+120#X軸の最大値
xint=30#X軸の間隔
ymin=-20#Y軸の最小値
ymax=80#Y軸の最大値
yint=20#Y軸の間隔
plot(xID1_36f7_200328_light,ypeakIDm1_36f7_200328_light_Zscore,type="l", pch=16, cex=1, lwd=1,las=1, col="gray", bg="transparent", xlim=c(xmin, xmax), ylim=c(ymin, ymax),axes=FALSE,an=FALSE)
axis(2,at=seq(ymin, ymax,yint), tcl=0.3, mgp=c(1,0.5,0.5),lwd=2,las=1)
axis(1,at=seq(xmin, xmax, xint), labels=c("-120","-90","-60","-30","0","30","60","90","120"), tcl=0.3, mgp=c(0,0.3,0),lwd=2,las=1)

mtext("Z score", side=2, line=2.5, cex=1)
mtext("Time (sec)", side=1, line=1.5, cex=1)

par(new=T)  #上書き指定

plot(xID2_36f7_200328_light,ypeakIDm2_36f7_200328_light_Zscore,type="l", pch=16, cex=1, lwd=1,las=1, col="gray", bg="transparent", xlim=c(xmin, xmax), ylim=c(ymin, ymax),axes=FALSE,an=FALSE)

par(new=T)  #上書き指定

plot(xID3_36f7_200328_light,ypeakIDm3_36f7_200328_light_Zscore,type="l", pch=16, cex=1, lwd=1,las=1, col="gray", bg="transparent", xlim=c(xmin, xmax), ylim=c(ymin, ymax),axes=FALSE,an=FALSE)

par(new=T)  #上書き指定

plot(xID4_36f7_200328_light,ypeakIDm4_36f7_200328_light_Zscore,type="l", pch=16, cex=1, lwd=1,las=1, col="gray", bg="transparent", xlim=c(xmin, xmax), ylim=c(ymin, ymax),axes=FALSE,an=FALSE)

par(new=T)  #上書き指定

plot(xID5_36f7_200328_light,ypeakIDm5_36f7_200328_light_Zscore,type="l", pch=16, cex=1, lwd=1,las=1, col="gray", bg="transparent", xlim=c(xmin, xmax), ylim=c(ymin, ymax),axes=FALSE,an=FALSE)

par(new=T)  #上書き指定

plot(xID6_36f7_200328_light,ypeakIDm6_36f7_200328_light_Zscore,type="l", pch=16, cex=1, lwd=1,las=1, col="gray", bg="transparent", xlim=c(xmin, xmax), ylim=c(ymin, ymax),axes=FALSE,an=FALSE)

par(new=T)  #上書き指定

plot(xIDave_36f7_200328_light,yIDave_36f7_200328_light_Zscore,type="l", pch=16, cex=1, lwd=1,las=1, col="black", bg="transparent", xlim=c(xmin, xmax), ylim=c(ymin, ymax),axes=FALSE,an=FALSE)

dev.off()

par(mfrow=c(1,1))#Quartzデバイスに出力する際にひとつのウインドウに出力するグラフの数を指定します。現在はひとつのグラフを描きます。
par(pin=c(2.0,0.8), cex=12/12)#plotSizeを規定します。現在は3x2インチ。cex=12/12は文字サイズなどが12ポイントであることを示す。

png("Kiss1-36f7_200328_light_peak_Zscore_all_sem.png", width = 400, height = 300, bg="transparent") 
#X軸、Y軸を表示します。
xmin=-120#X軸の最小値
xmax=+120#X軸の最大値
xint=30#X軸の間隔
ymin=-20#Y軸の最小値
ymax=80#Y軸の最大値
yint=20#Y軸の間隔
plot(xIDave_36f7_200328_light,yIDave_36f7_200328_light_Zscore,type="l", pch=16, cex=1, lwd=1,las=1, col="black", bg="transparent", xlim=c(xmin, xmax), ylim=c(ymin, ymax),axes=FALSE,an=FALSE)

axis(2,at=seq(ymin, ymax,yint), tcl=0.3, mgp=c(1,0.5,0.5),lwd=2,las=1)
axis(1,at=seq(xmin, xmax, xint), labels=c("-120","-90","-60","-30","0","30","60","90","120"), tcl=0.3, mgp=c(0,0.3,0),lwd=2,las=1)

mtext("Z score", side=2, line=2.5, cex=1)
mtext("Time (sec)", side=1, line=1.5, cex=1)

par(new=T)  #上書き指定

polygon(c(xIDave_36f7_200328_light,rev(xIDave_36f7_200328_light)), c(yIDave_36f7_200328_light_Zscore+yIDsem_36f7_200328_light_Zscore,rev(yIDave_36f7_200328_light_Zscore-yIDsem_36f7_200328_light_Zscore)),col="gray",lty=0)

par(new=T)  #上書き指定

plot(xIDave_36f7_200328_light,yIDave_36f7_200328_light_Zscore,type="l", pch=16, cex=1, lwd=1,las=1, col="black", bg="transparent", xlim=c(xmin, xmax), ylim=c(ymin, ymax),axes=FALSE,an=FALSE)

dev.off()






#shape analysis (left, right, FWHM)
xID_36f7_200328_light<-c("dark_ID1","dark_ID2","dark_ID3","dark_ID4","dark_ID5","dark_ID6")#IDの数に合わせる！！

#left edgeの平均値などを求める
###
leftedge_halfmax_36f7_200328_light<-c(x_leftedge_halfmax_peakID1_36f7_200328_light,x_leftedge_halfmax_peakID2_36f7_200328_light,x_leftedge_halfmax_peakID3_36f7_200328_light,x_leftedge_halfmax_peakID4_36f7_200328_light,x_leftedge_halfmax_peakID5_36f7_200328_light,x_leftedge_halfmax_peakID6_36f7_200328_light)
###
leftedge_thirdmax_36f7_200328_light<-c(x_leftedge_thirdmax_peakID1_36f7_200328_light,x_leftedge_thirdmax_peakID2_36f7_200328_light,x_leftedge_thirdmax_peakID3_36f7_200328_light,x_leftedge_thirdmax_peakID4_36f7_200328_light,x_leftedge_thirdmax_peakID5_36f7_200328_light,x_leftedge_thirdmax_peakID6_36f7_200328_light)
###
leftedge_fourthmax_36f7_200328_light<-c(x_leftedge_fourthmax_peakID1_36f7_200328_light,x_leftedge_fourthmax_peakID2_36f7_200328_light,x_leftedge_fourthmax_peakID3_36f7_200328_light,x_leftedge_fourthmax_peakID4_36f7_200328_light,x_leftedge_fourthmax_peakID5_36f7_200328_light,x_leftedge_fourthmax_peakID6_36f7_200328_light)

data_leftedge_halfmax_36f7_200328_light<-data.frame(xID_36f7_200328_light,leftedge_halfmax_36f7_200328_light)
write.csv(data_leftedge_halfmax_36f7_200328_light, "Kiss1-36f7_200328_light_lefthalf.csv")

data_leftedge_thirdmax_36f7_200328_light<-data.frame(xID_36f7_200328_light,leftedge_thirdmax_36f7_200328_light)
write.csv(data_leftedge_thirdmax_36f7_200328_light, "Kiss1-36f7_200328_light_leftthird.csv")

data_leftedge_fourthmax_36f7_200328_light<-data.frame(xID_36f7_200328_light,leftedge_fourthmax_36f7_200328_light)
write.csv(data_leftedge_fourthmax_36f7_200328_light, "Kiss1-36f7_200328_light_leftfourth.csv")


#right edgeの平均値などを求める
###
rightedge_halfmax_36f7_200328_light<-c(x_rightedge_halfmax_peakID1_36f7_200328_light,x_rightedge_halfmax_peakID2_36f7_200328_light,x_rightedge_halfmax_peakID3_36f7_200328_light,x_rightedge_halfmax_peakID4_36f7_200328_light,x_rightedge_halfmax_peakID5_36f7_200328_light,x_rightedge_halfmax_peakID6_36f7_200328_light)
###
rightedge_thirdmax_36f7_200328_light<-c(x_rightedge_thirdmax_peakID1_36f7_200328_light,x_rightedge_thirdmax_peakID2_36f7_200328_light,x_rightedge_thirdmax_peakID3_36f7_200328_light,x_rightedge_thirdmax_peakID4_36f7_200328_light,x_rightedge_thirdmax_peakID5_36f7_200328_light,x_rightedge_thirdmax_peakID6_36f7_200328_light)
###
rightedge_fourthmax_36f7_200328_light<-c(x_rightedge_fourthmax_peakID1_36f7_200328_light,x_rightedge_fourthmax_peakID2_36f7_200328_light,x_rightedge_fourthmax_peakID3_36f7_200328_light,x_rightedge_fourthmax_peakID4_36f7_200328_light,x_rightedge_fourthmax_peakID5_36f7_200328_light,x_rightedge_fourthmax_peakID6_36f7_200328_light)

data_rightedge_halfmax_36f7_200328_light<-data.frame(xID_36f7_200328_light,rightedge_halfmax_36f7_200328_light)
write.csv(data_rightedge_halfmax_36f7_200328_light, "Kiss1-36f7_200328_light_righthalf.csv")

data_rightedge_thirdmax_36f7_200328_light<-data.frame(xID_36f7_200328_light,rightedge_thirdmax_36f7_200328_light)
write.csv(data_rightedge_thirdmax_36f7_200328_light, "Kiss1-36f7_200328_light_rightthird.csv")

data_rightedge_fourthmax_36f7_200328_light<-data.frame(xID_36f7_200328_light,rightedge_fourthmax_36f7_200328_light)
write.csv(data_rightedge_fourthmax_36f7_200328_light, "Kiss1-36f7_200328_light_rightfourth.csv")

#FWHMの平均値などを求める
###
fwhm_36f7_200328_light<-c(fwhm_peakID1_36f7_200328_light,fwhm_peakID2_36f7_200328_light,fwhm_peakID3_36f7_200328_light,fwhm_peakID4_36f7_200328_light,fwhm_peakID5_36f7_200328_light,fwhm_peakID6_36f7_200328_light)
###
fw3rdm_36f7_200328_light<-c(fw3rdm_peakID1_36f7_200328_light,fw3rdm_peakID2_36f7_200328_light,fw3rdm_peakID3_36f7_200328_light,fw3rdm_peakID4_36f7_200328_light,fw3rdm_peakID5_36f7_200328_light,fw3rdm_peakID6_36f7_200328_light)
###
fw4thm_36f7_200328_light<-c(fw4thm_peakID1_36f7_200328_light,fw4thm_peakID2_36f7_200328_light,fw4thm_peakID3_36f7_200328_light,fw4thm_peakID4_36f7_200328_light,fw4thm_peakID5_36f7_200328_light,fw4thm_peakID6_36f7_200328_light)

data_fwhm_36f7_200328_light<-data.frame(xID_36f7_200328_light,fwhm_36f7_200328_light)
write.csv(data_fwhm_36f7_200328_light, "Kiss1-36f7_200328_light_fwhm.csv")

data_fw3rdm_36f7_200328_light<-data.frame(xID_36f7_200328_light,fw3rdm_36f7_200328_light)
write.csv(data_fw3rdm_36f7_200328_light, "Kiss1-36f7_200328_light_fw3rdm.csv")

data_fw4thm_36f7_200328_light<-data.frame(xID_36f7_200328_light,fw4thm_36f7_200328_light)
write.csv(data_fw4thm_36f7_200328_light, "Kiss1-36f7_200328_light_fw4thm.csv")


#base lineのばらつきの評価
###
CV_left_base_36f7_200328_light_30<-c(CV_left_base_peakIDm1_36f7_200328_light_30,CV_left_base_peakIDm2_36f7_200328_light_30,CV_left_base_peakIDm3_36f7_200328_light_30,CV_left_base_peakIDm4_36f7_200328_light_30,CV_left_base_peakIDm5_36f7_200328_light_30,CV_left_base_peakIDm6_36f7_200328_light_30)
###
CV_left_base_36f7_200328_light_60<-c(CV_left_base_peakIDm1_36f7_200328_light_60,CV_left_base_peakIDm2_36f7_200328_light_60,CV_left_base_peakIDm3_36f7_200328_light_60,CV_left_base_peakIDm4_36f7_200328_light_60,CV_left_base_peakIDm5_36f7_200328_light_60,CV_left_base_peakIDm6_36f7_200328_light_60)
###
CV_left_base_36f7_200328_light_90<-c(CV_left_base_peakIDm1_36f7_200328_light_90,CV_left_base_peakIDm2_36f7_200328_light_90,CV_left_base_peakIDm3_36f7_200328_light_90,CV_left_base_peakIDm4_36f7_200328_light_90,CV_left_base_peakIDm5_36f7_200328_light_90,CV_left_base_peakIDm6_36f7_200328_light_90)

data_CV_left_base_36f7_200328_light_30<-data.frame(xID_36f7_200328_light,CV_left_base_36f7_200328_light_30)
write.csv(data_CV_left_base_36f7_200328_light_30, "Kiss1-36f7_200328_light_CV_left_30.csv")

data_CV_left_base_36f7_200328_light_60<-data.frame(xID_36f7_200328_light,CV_left_base_36f7_200328_light_60)
write.csv(data_CV_left_base_36f7_200328_light_60, "Kiss1-36f7_200328_light_CV_left_60.csv")

data_CV_left_base_36f7_200328_light_90<-data.frame(xID_36f7_200328_light,CV_left_base_36f7_200328_light_90)
write.csv(data_CV_left_base_36f7_200328_light_90, "Kiss1-36f7_200328_light_CV_left_90.csv")

###
CV_right_base_36f7_200328_light_30<-c(CV_right_base_peakIDm1_36f7_200328_light_30,CV_right_base_peakIDm2_36f7_200328_light_30,CV_right_base_peakIDm3_36f7_200328_light_30,CV_right_base_peakIDm4_36f7_200328_light_30,CV_right_base_peakIDm5_36f7_200328_light_30,CV_right_base_peakIDm6_36f7_200328_light_30)
###
CV_right_base_36f7_200328_light_60<-c(CV_right_base_peakIDm1_36f7_200328_light_60,CV_right_base_peakIDm2_36f7_200328_light_60,CV_right_base_peakIDm3_36f7_200328_light_60,CV_right_base_peakIDm4_36f7_200328_light_60,CV_right_base_peakIDm5_36f7_200328_light_60,CV_right_base_peakIDm6_36f7_200328_light_60)
###
CV_right_base_36f7_200328_light_90<-c(CV_right_base_peakIDm1_36f7_200328_light_90,CV_right_base_peakIDm2_36f7_200328_light_90,CV_right_base_peakIDm3_36f7_200328_light_90,CV_right_base_peakIDm4_36f7_200328_light_90,CV_right_base_peakIDm5_36f7_200328_light_90,CV_right_base_peakIDm6_36f7_200328_light_90)

data_CV_right_base_36f7_200328_light_30<-data.frame(xID_36f7_200328_light,CV_right_base_36f7_200328_light_30)
write.csv(data_CV_right_base_36f7_200328_light_30, "Kiss1-36f7_200328_light_CV_right_30.csv")

data_CV_right_base_36f7_200328_light_60<-data.frame(xID_36f7_200328_light,CV_right_base_36f7_200328_light_60)
write.csv(data_CV_right_base_36f7_200328_light_60, "Kiss1-36f7_200328_light_CV_right_60.csv")

data_CV_right_base_36f7_200328_light_90<-data.frame(xID_36f7_200328_light,CV_right_base_36f7_200328_light_90)
write.csv(data_CV_right_base_36f7_200328_light_90, "Kiss1-36f7_200328_light_CV_right_90.csv")
